#include <string.h>
#include <limits.h>

const int range = CHAR_MAX+1;    // zakres: 0 ... CHAR_MAX

struct state
{
  state* transition[ range ];
            state(); 
};

class fsm 
{
  state   graph[6];            // graf przejsc, 0 oznacza stan koncowy
  state* current;              // = &s1, .... &s6; NULL -> zawieszenie
public:   
  void reset();                 // ustaw w stan poczatkowy
  void advance(char);     // wykonaj jedno przejscie
  int end_state();     
  int doom_state();  
       fsm();                      // konstruktor
};

state::state()                   // konstruktor zeruje macierz przejsc
{
  for( int i = 0; i < range; ++i )
     transition[ i ] = NULL;
}

struct triple
{
  int from;             // stan wyjsciowy (z-)
  char input;             // wejsciowy sygnal (znak) sterujacy
  int to;	                  // stan koncowy (do-)
};

fsm::fsm()            // konstruktor; edge = ramie grafu
{
  static triple edges[] =
    {
        (1, 'A', 2), (1, 'B', 3), (1, 'C', 4), (1, 'D', 5),
        (2, 'E', 2), (2, 'I', 0), 
        (3, 'F', 3), (3, 'J', 0), (3, 'M', 4), 
        (4, 'G', 4), (4, 'K', 0), 
        (5, 'H', 5), (5, 'L', 0), (5, 'O', 2), (5, 'N', 4),
        (0, 0, 0)
     };
  for( triple* e = edges; e->from != 0; ++e )
       graph[ e->from ].transition[ e->input ] = &graph[ e->to ];
  current = NULL;
}

void fsm::reset() 
{
  current = &graph[1]; 
}

void fsm::advance(char x) 
{
  if( current ) 
    current = current->transition[ x ]; 
}

int fsm::end_state() 
{
  return current == &graph[0]; 
}

int fsm::doom_state() 
{
  return current == NULL;   
}

#include <stdio.h>

main()
{
  char input_string[80];  
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  fsm m;
  m.reset();
  int index = 0;
  m.advance( input_string[ index++ ] );
  while( !m.end_state() && !m.doom_state() )
  {
       m.advance( input_string[ index++ ] );
  }
  if( m.end_state() )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
