#include <string.h> 

class parent 
{
  static parent *current;    // = &s1, .... &s6; NULL -> zawieszenie
protected:
  virtual parent* transition(char) {}   // funkcja przejsc
public:                                 // interfejs - metody statyczne
  static void reset();                  // ustaw w stan poczatkowy
  static void advance(char);            // wykonaj jedno przejscie
  static int end_state();     
  static int doom_state();  
};

struct state1 : public parent                
{
  parent* transition(char);                         
};

// ...

struct state6 : public parent                
{
  parent* transition(char);                         
};

parent* parent::current = NULL;

state1 s1;   
state2 s2;
state3 s3;
state4 s4;
state5 s5;
state6 s6;

void parent::reset() 
{
  current = &s1;                // ustaw w stan poczatkowy s1
}

void parent::advance(char x) 
{
  if( current )                                       // jesli to nie jest zawieszenie
    current = current->transition(x);    // przejdz do stanu...
}

int parent::end_state() 
{
  return current == &s6;            // stan koncowy
}

int parent::doom_state() 
{
  return current == NULL;        // stan zawieszenia
}

parent* state1::transition(char x) 
{
    switch( x )
      {
         case 'A':  return &s2;
         case 'B':  return &s3;
         case 'C':  return &s4;
         case 'D':  return &s5;
         default: return NULL;                  
      }
}

// ...

parent* state6::transition() 
{
  return NULL;
}

#include <stdio.h>

main()
{
  char input_string[80];  
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  parent::reset();
  int index = 0;
  parent::advance( input_string[ index++ ] );
  while( !parent::end_state() && !parent::doom_state() )
  {
     parent::advance( input_string[ index++ ] );
  }
  if( parent::end_state() )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
