#include <string.h> 

struct parent                  // struktura bazowa
{
  static char* expression;      // wyrazenie jako lancuch znakw
  static int index;
  static int end_state;    // flaga, 1, gdy osiagnieto stan koncowy, inaczej: 0
  static int doom_state;   // 1, jesli nielegalny znak na We, inaczej: 0
  parent( char* expr );       // konstruktor
  virtual parent* transition() {}     // funkcja przejscia, wirtualna
};

parent::parent( char* expr )        // konstr. konwersji
{
  expression = new char[ strlen( expr ) ];    // przydzielenie pamieci
  strcpy( expression, expr );                 // skopiowanie wyrazenia 
  end_state = 0	;                        // to nie koniec
  doom_state = 0;                              // to nie stan zawieszenia
  index = 0;             // zerujemy indeks - licznik
}

struct state1 : public parent         // opis stanu (1)
{
  parent *ptr2, *ptr3, *ptr4, *ptr5;  // wskaz. do stanw nastepnych
  state1() : parent( expression ) {}  // inicjator kons. str. bazowej
  parent* transition();               // funkcja przejscia
};

struct state2 : public parent        // opis stanu (2)
{
  parent *ptr2;                      // wskaz. do stanw nastepnych
  state2() : parent( expression ) {}   // konstruktor
  parent* transition();              // funkcja przejscia
};
 
struct state3 : public parent         // opis stanu (3)
{
  parent *ptr3, *ptr4; 
  state3() : parent( expression ) {}    
  parent* transition(); 
};

struct state4 : public parent          // opis stanu (4)
{
  parent *ptr4; 
  state4() : parent( expression ) {}    
  parent* transition(); 
};

struct state5 : public parent           // opis stanu (5)
{
  parent *ptr2, *ptr4, *ptr5;  
  state5() : parent( expression ) {} 
  parent* transition();  
};

parent* state1::transition()     // implementacja f. przejscia
{
    switch( expression[ index++ ] )
      {
         case 'A':  return ptr2;
         case 'B':  return ptr3;
         case 'C':  return ptr4;
         case 'D':  return ptr5;
         case '\0':  doom_state = 1;
         default: doom_state = 1;   
       }
}

parent* state2::transition() 
{
    switch( expression[ index++ ] )
      {
         case 'E':  return ptr2;
         case 'I':  end_state = 1; break;
         case '\0':  doom_state = 1;
         default: doom_state = 1;   
       }
}

parent* state3::transition() 
{
    switch( expression[ index++ ] )
      {
         case 'F':  return ptr3;
         case 'M':  return ptr4;
         case 'J':  end_state = 1; break;
         case '\0':  doom_state = 1;
         default: doom_state = 1; 
       }
}

parent* state4::transition() 
{
    switch( expression[ index++ ] )
      {
         case 'G':  return ptr4;
         case 'K':  end_state = 1; break;
         case '\0':  doom_state = 1;
         default: doom_state = 1; 
       }
}

parent* state5::transition() 
{
    switch( expression[ index++ ] )
      {
         case 'O':  return ptr2;
         case 'H':  return ptr5;
         case 'L':  end_state = 1; break;
         case 'N':  return ptr4;
         case '\0':  doom_state = 1;
         default: doom_state = 1; 
       }
}

char* parent::expression = NULL;
int parent::doom_state = 0;
int parent::end_state = 0;
int parent::index = 0;

state1 s1;         // deklarujemy obiekty s1 ... s5
state2 s2;
state3 s3;
state4 s4;
state5 s5;

void build_state_machine()  // budujemy ramiona grafu
{
  s1.ptr2 = &s2;
  s1.ptr3 = &s3;
  s1.ptr4 = &s4;
  s1.ptr5 = &s5;
  s2.ptr2 = &s2;
  s3.ptr3 = &s3;
  s3.ptr4 = &s4;
  s4.ptr4 = &s4;
  s5.ptr2 = &s2;
  s5.ptr4 = &s4;
  s5.ptr5 = &s5;
}

#include <stdio.h>

main()
{
  build_state_machine();
  char input_string[80];           // wejsciowy lancuch znakw
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  parent state_machine(input_string);
  parent *ptr;
  ptr = s1.transition();
  while( ptr->end_state != 1 && ptr->doom_state != 1 )
  {
     ptr = ptr->transition();
  }
  if( ptr->end_state == 1 )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
