#include <fstream.h>

class Index
{
  friend class FileArray;		// 'zaprzyjazniona' klasa
  FileArray* fa;                   // wskaznik do obiektu 
  streampos filePtr;
            Index(FileArray* _fa, int x);        // konstruktor
public:
Index& operator= (char c);
                    operator char();
};

class FileArray
{
friend class Index;           // 'zaprzyjazniona' klasa
  FileArray& operator=(const FileArray&);  
  fstream fs;
public:
  FileArray(char* fName) : fs(fName, ios::in | ios::out) {}
  Index operator[] (unsigned x);
};

Index::Index(FileArray* _fa, int x)
{
  fa = _fa;
  filePtr = streampos(x);
}

Index& Index::operator= (char c)
{
  fa->fs.seekp(filePtr, ios::beg);
  fa->fs.write(&c, 1);
  fa->fs.flush();
  return *this;
}

Index::operator char()
{
  char c;
  fa->fs.seekg(filePtr, ios::beg);
  fa->fs.read(&c, 1);
  return c;
}

Index FileArray::operator[] (unsigned x)
{
  return Index(this, x);
}
