#include <assert.h>
#include <string.h>

class StackIndex {	// klasa bazowa "indeksacja stosu"
                        // prywatne pola danych
  int top;		// top - to 'wierzcholek stosu'
  int size;		// size - to rozmiar
public:			// publiczny interfejs klasy bazowej
  StackIndex(int sz);	// konstruktor ogolny
  ~StackIndex();	// destruktor klasy bazowej
  int  push();		// metoda 'odloz na stos'
  int  pop();		// metoda 'zdejm ze stosu'
};

StackIndex::StackIndex(int sz)
{
  size = sz;
  top = 0;
}

StackIndex::~StackIndex() {}	// "pusty" destruktor

int StackIndex::push()
{
  assert(top < size);
  return top++;
}

int StackIndex::pop()
{
  assert(top > 0);
  return --top;
}

const int defaultStack = 128;  	// domyslny rozmiar stosu

class CharStack : public StackIndex
{
  char *data;		      	// prywatny wskaznik do danych
public:
  CharStack();			// kosntr. domyslny
  CharStack(int size);
  CharStack(int size, char *init);
  ~CharStack();

  void push(char);
  char pop();
};


CharStack::CharStack() : StackIndex( defaultStack )
{
  data = new char[defaultStack];
}

CharStack::CharStack(int size) : StackIndex(size)
{
  data = new char[size];
}

CharStack::CharStack(int size, char *init) : StackIndex(size)
{
  data = new char[size];
  for(int i=0; i<strlen(init); ++i)
    *((char*) StackIndex::push()) = init[i];
}

CharStack::~CharStack()
{
  delete [] data;
}

void CharStack::push(char d)
{
  data[StackIndex::push()] = d;
}

char CharStack::pop()
{
  return data[StackIndex::pop()];
}

class IntStack : public StackIndex
{
  int *data;		      	// prywatny wskaznik do danych
public:
  IntStack();			// konstr. domyslny
  IntStack(int size);
  ~IntStack();

  void push(int);
  int  pop();
};


IntStack::IntStack() : StackIndex( defaultStack )
{
  data = new int[defaultStack];
}

IntStack::IntStack(int size) : StackIndex(size)
{
  data = new int[size];
}

IntStack::~IntStack()
{
  delete [] data;
}

void IntStack::push(int d)
{
  data[StackIndex::push()] = d;
}

int IntStack::pop()
{
  return data[StackIndex::pop()];
}
