#include <assert.h>
#include <string.h>

class Stack {		// klasa nazowa "stos"
  int top;		// wierzcholek stosu
  int size;		// rozmiar
protected:		// dostepne tylko dla klas pochodnych
  void **vec;		// tablica wskaznikow (wektor)
public:			// publiczny interfejs klasy bazowej
  Stack(int sz);	// konstruktor ogolny
  ~Stack();		// destruktor klasy bazowej
void* push();		// metoda 'odloz na stos'
void* pop();		// metoda 'zdejm ze stosu'
};

Stack::Stack(int sz)	// definicja konstruktora
{
  vec = new void*[size=sz];
  top = 0;
}

Stack::~Stack()
{
  delete [] vec;      	// zwalnia pamiec zajmowana przez tablice wskaznikow
}

void* Stack::push()
{
  assert(top < size);
  return vec[top++];
}

void* Stack::pop()
{
  assert(top > 0);
  return vec[--top];
}

const int defaultStack = 128;  	// domyslny rozmiar stosu

class CharStack : public Stack
{
  char *data;		      	// prywatny wskaznik do danych
public:
  CharStack();			// kosntr. domyslny
  CharStack(int size);
  CharStack(int size, char *init);
  ~CharStack();

void push(char);
char pop();
};


CharStack::CharStack() : Stack( defaultStack )
{
  data = new char[defaultStack];
  for( int i=0; i<defaultStack; ++i)
    vec[i] = &data[i];
}

CharStack::CharStack(int size) : Stack(size)
{
  data = new char[size];
  for( int i=0; i<size; ++i)
    vec[i] = &data[i];
}

CharStack::CharStack(int size, char *init) : Stack(size)
{
  data = new char[size];
  for( int i=0; i<size; ++i)
    vec[i] = &data[i];
  for(int i=0; i<strlen(init); ++i)
    *((char*) Stack::push()) = init[i];
}

CharStack::~CharStack()
{
  delete [] data;
}

void CharStack::push(char d)
{
  *((char*) Stack::push()) = d;
}

char CharStack::pop()
{
  return *((char*) Stack::pop());
}

class IntStack : public Stack
{
  int *data;		      	// prywatny wskaznik do danych
public:
  IntStack();			// konstr. domyslny
  IntStack(int size);
  ~IntStack();

void push(int);
int  pop();
};


IntStack::IntStack() : Stack( defaultStack )
{
  data = new int[defaultStack];
  for( int i=0; i<defaultStack; ++i)
    vec[i] = &data[i];
}

IntStack::IntStack(int size) : Stack(size)
{
  data = new int[size];
  for( int i=0; i<size; ++i)
    vec[i] = &data[i];
}

IntStack::~IntStack()
{
  delete [] data;
}

void IntStack::push(int d)
{
  *((int*) Stack::push()) = d;
}

int IntStack::pop()
{
  return *((int*) Stack::pop());
}
