#include <stdio.h>

enum CARD { CDROM, TAPE, NETWORK };
enum MONITOR { MONO, COLOR };

class Component {
  int price_;
  char *name_;
  int rebate_;
public:
	Component( int p, char *n, int r=0);
  int netPrice();
  int price() { return price_; }
  char *name(){ return name_; }
  int rebate(){ return rebate_; } 
};

Component::Component( int p, char *n, int r)
{
  price_ = p;
  name_ = n;
  rebate_ = r;
}

int Component::netPrice()
{
  return price_ - rebate_;
}

Component Network(600, "Karta sieciowa", 45);
Component CDRom(1500, "CDRom", 135);
Component Tape(1000, "Streamer tasmowy", 45);
Component Color(1500, "Monitor Kolorowy");
Component Monochrome(1500, "Monitor Mono");

class Computer {
  Component *card;
  Component *mon;
public:
  Computer( CARD, MONITOR );
  int netPrice();
  void print();
};

int Computer::netPrice()
{
  return mon->netPrice() + card->netPrice();
}

Computer::Computer( CARD c, MONITOR m)
{
  switch( c ) {
  case NETWORK: card = &Network;  break;
  case CDROM: card = &CDRom;  break;
  case TAPE: card = &Tape;  break;
  }
  switch( m ) {
  case MONO: mon = &Monochrome;  break;
  case COLOR: mon = &Color;  break;
  }
}

void Computer::print()
{
  printf("%s %s, cena netto = %d\n", card->name(), 
mon->name(), netPrice());
}

int main()
{
  Computer mn( NETWORK, MONO );
  Computer mc( CDROM, MONO );
  Computer mt( TAPE, MONO );
  Computer cn( NETWORK, COLOR );
  Computer cc( CDROM, COLOR );
  Computer ct( TAPE, COLOR );

  mn.print();
  mc.print();
  mt.print();
  cn.print();
  cc.print();
  ct.print();

  return 0;
}
