#include <iostream.h>

class Top {
  int x;
public:
  Top();
  Top(const Top &);
  Top & operator=(const Top &);
};

Top::Top() : x(0)
{
  cout << "\tTop::Top() this=" << this << "\n";
}

Top::Top(const Top & t) : x(t.x)
{
  cout << "\tTop::Top(const Top &) this=" << this << "\n";
}

Top & Top::operator=(const Top & rhs)
{
  cout << "\tTop::operator=() this=" << this << "\n";
  if( this != &rhs )
     x = rhs.x;
  return *this;
}
  
class Left : public virtual Top {
  int y;
// ...
};

class Right : public virtual Top {
  int z;
// ...
};

class Bottom : public Left, public Right {
// ...
};

int main()
{
  cout << "Pierwszy obiekt klasy pochdnej: Bottom first; \n";
  Bottom first;
  cout << "Przypisanie (kopiowanie) obiektu: Bottom copy = first;";
  Bottom copy = first;
  cout << "Przypisanie obiektu: copy = first;";
  copy = first;
  return 0;
}
