class Clock : public TimerClient, public WindowClient
{
  Timer *timer;
  Window *win;
  void display(); 
public: 
  Clock();
  ~Clock();          
  void tick();     // Timer callback, odwolanie do ob. klasy Timer
  void refresh();  // Window callback, odwolanie do ob. klasy Window
};

Clock::Clock()
{
  timer = new Timer(5, this);
  win = new Window(this);
  assert( timer != NULL && win != NULL );
}

Clock::~Clock()
{
  delete timer;
  delete win;
}

void Clock::tick()
{
  display();
}

void Clock::refresh()
{
  display();
}

void Clock::display()
{
  time_t time_of_day;            // czas rzeczywisty
  time( &time_of_day );
  const int size = 128; 
  char buffer[ size ];
  strftime( buffer, size, "%H:%M:%S", localtime(&time_of_day);
  win->write(buffer);
}
