#include <string.h>
#include <limits.h>

const int range = CHAR_MAX+1;    // zakres: 0 ... CHAR_MAX

struct state
{
  state* transition[ range ];
            state(); 
};

struct triple
{
  int from;             // stan biezacy (z-)
  char input;             // wejsciowy sygnal (znak) sterujacy
  int to;	                  // stan nastepny (do-)
};

class fsm 
{
  state*   graph;            // graf przejsc, [0] oznacza stan koncowy
  state* current;             // = &graph[0] ... &graph[N-1] 
                                      // stan: NULL = zawieszenie (doom)
public:   
  void reset();                 // ustaw w stan poczatkowy
  void advance(char);     // wykonaj jedno przejscie
  int end_state();     
  int doom_state();  
       fsm(triple*);             // konstruktor
  virtual ~fsm();               // destruktor
};

state::state() 
{
  for( int i = 0; i < range; ++i )
     transition[ i ] = NULL;
}

fsm::fsm(triple* p)
{
  int max_node;      // rozmiar dynamicznie zapamietanego grafu
  for( triple *e = p; e->from; ++e )
    {
       if( e->from > max_node ) max_node = e->from;
       if( e->to > max_node ) max_node = e->to;
    }
  graph = new state[ max_node+1 ];
  for( triple *e = p; e->from; ++e )  
       graph[ e->from ].transition[ e->input ] = &graph[ e->to ];
       current = NULL;
}

fsm::~fsm()
{
  delete [] graph;
}

void fsm::reset() 
{
  current = &graph[1]; 
}

void fsm::advance(char x) 
{
  if( current ) 
    current = current->transition[ x ]; 
}

int fsm::end_state() 
{
  return current == &graph[0]; 
}

int fsm::doom_state() 
{
  return current == NULL;   
}

class sample : public fsm     // klasa pochodna, prbka
{
  static triple edges[];
public:
  sample();                              // konstr. klasy pochodnej
};

triple sample::edges[] =
    {
        (1, 'A', 2), (1, 'B', 3), (1, 'C', 4), (1, 'D', 5),
        (2, 'E', 2), (2, 'I', 0), 
        (3, 'F', 3), (3, 'J', 0), (3, 'M', 4), 
        (4, 'G', 4), (4, 'K', 0), 
        (5, 'H', 5), (5, 'L', 0), (5, 'O', 2), (5, 'N', 4),
        (0, 0, 0)
     };

sample::sample() : fsm( edges )
{
}

#include <stdio.h>

main()
{
  char input_string[80];  
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  sample m;
  m.reset();
  int index = 0;
  m.advance( input_string[ index++ ] );
  while( !m.end_state() && !m.doom_state() )
  {
       m.advance( input_string[ index++ ] );
  }
  if( m.end_state() )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
