#include <string.h>

struct state
{
  virtual state* transition(char) = 0;
};

class fsm 
{
  state* current;              // = &s1, .... &s6; NULL -> zawieszenie
public:   
  void reset();                // ustaw w stan poczatkowy
  void advance(char);          // wykonaj jedno przejscie
  int end_state();     
  int doom_state();  
  fsm();                       // konstruktor
};

struct state1 : public state
{
  state* transition(char); 
};

// ...

struct state6 : public state
{
  state* transition(char); 
};

state1 s1;   
state2 s2;
state3 s3;
state4 s4;
state5 s5;
state6 s6;

fsm::fsm() 
{
  current = NULL;
}

void fsm::reset() 
{
  current = &s1; 
}

void fsm::advance(char x) 
{
  if( current ) 
    current = current->transition(x); 
}

int fsm::end_state() 
{
  return current == &s6; 
}

int fsm::doom_state() 
{
  return current == NULL;   
}

state* state1::transition(char x) 
{
    switch( x )
      {
         case 'A':  return &s2;
         case 'B':  return &s3;
         case 'C':  return &s4;
         case 'D':  return &s5;
         default: return NULL;                  
       }
}

// ...

state* state6::transition() 
{
  return NULL;
}

#include <stdio.h>

main()
{
  char input_string[80];  
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  fsm m;
  m.reset();
  int index = 0;
  m.advance( input_string[ index++ ] );
  while( !m.end_state() && !m.doom_state() )
  {
       m.advance( input_string[ index++ ] );
  }
  if( m.end_state() )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
