#include <string.h>

struct state                        // abstr. struktura bazowa stanw
{
  virtual state* transition(char) = 0;
};

class fsm                          // model automatu FSM
{
  static state* current;              // = &s1, .... &s6; NULL -> zawieszenie
public:   
  static void reset();                 // ustaw w stan poczatkowy
  static void advance(char);     // wykonaj jedno przejscie
  static int end_state();     
  static int doom_state();  
};

struct state1 : public state
{
  state* transition(char); 
};

// ...

struct state6 : public state
{
  state* transition(char); 
};

state* fsm::current = NULL;

state1 s1;   
state2 s2;
state3 s3;
state4 s4;
state5 s5;
state6 s6;

void fsm::reset() 
{
  current = &s1; 
}

void fsm::advance(char x) 
{
  if( current ) 
    current = current->transition(x); 
}

int fsm::end_state() 
{
  return current == &s6;               // stan koncowy
}

int fsm::doom_state() 
{
  return current == NULL;              // stan zawieszenia
}

state* state1::transition(char x) 
{
    switch( x )
      {
         case 'A':  return &s2;
         case 'B':  return &s3;
         case 'C':  return &s4;
         case 'D':  return &s5;
         default: return NULL;                  
       }
}

// ...

state* state6::transition() 
{
  return NULL;
}

#include <stdio.h>

main()
{
  char input_string[80];  
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  fsm::reset();
  int index = 0;
  fsm::advance( input_string[ index++ ] );
  while( !fsm::end_state() && !fsm::doom_state() )
  {
     fsm::advance( input_string[ index++ ] );
  }
  if( fsm::end_state() )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
