#include <stdio.h>
#include <stdlib.h>

class HeapStats {                 // klasa  modul
  friend void* operator new(size_t);
  friend void operator delete(void*);
  static int newN;                // ile razy wywolano 'new'
  static int deleteN;             // ile razy wywolano 'delete'
public: 
  static void report( FILE *f = stdout );
  static void reset();
};

int HeapStats::newN = 0;
int HeapStats::deleteN = 0;

void HeapStats:: report( FILE *f )
{
  fprintf( f, "Operator new byl wywolany %d razy.\n", newN );
  fprintf( f, "Operator delete byl wywolany %d razy.\n", deleteN );
  fflush(f);
}

void HeapStats:: reset()
{
  newN = 0;
  deleteN = 0;
}

void *operator new(size_t sz)     // statystyka i funkcja malloc()
{
  ++HeapStats::newN;
  return malloc(sz);
}

void operator delete(void* p)    // statystyka i funkcja free()
{
  ++HeapStats::deleteN;
  free(p);
}
