#include <stdio.h>

class BigInt {
  char* digits;
  unsigned  ndigits;
  BigInt(char* d, unsigned n) {
    digits = d;
    ndigits = n;
  }
  char fetch( int i ) const
  {
    return i < ndigits ? digits[ i ] : 0;
  }
public: 
  BigInt(const char*);
  BigInt(unsigned n=0);
  BigInt(const BigInt&);
  void operator=(const BigInt&);
  BigInt operator+(const BigInt&) const;
  void print(FILE* f = stdout) const;
  ~BigInt() { delete [] digits; }
};

BigInt BigInt:: operator+( const BigInt& n ) const
{
  unsigned maxDigits =
    (ndigits > n.ndigits ? ndigits : n.ndigits)+1;
  char* sumPtr = new char[ maxDigits ];
  BigInt sum( sumPtr, maxDigits );
  unsigned carry = 0; 
  for( int i = 0; i < maxDigits; ++i ) {
      *sumPtr = fetch(i) + n.fetch(i) + carry;
      if( *sumPtr >= 10) {
         carry = 1;
         *sumPtr -= 10;
      }
      else carry = 0;
      sumPtr++;  
  }
  return sum;
}
