#include <stdio.h>
#include <string.h>

class Vehicle
{
protected: 
  char *plate;                 // tekst na tablicy rejestracyjnej
public: 
  Vehicle() { plate = NULL; }
  Vehicle(char *p)
   {
      plate = new char[ strlen(p)+1 ];
      strcpy(plate, p);
   }
   ~Vehicle() { delete plate; }
virtual void identify()
   {
      printf("Jakis pojazd, pojecie oglne.");
   }
}; 

class Car : public Vehicle { // samochd osobowy
public:
  Car() : Vehicle() {}
  Car(char *p) : Vehicle(p) {}    // inicjator z przekazaniem argumentu
void identify()
   {
      printf("Samochd osobowy z numerem: %s.\n", plate);
   }
}; 

class Truck : public Vehicle {    // ciezarwka
public:
  Truck() : Vehicle() {}                 
  Truck(char *p) : Vehicle(p)  {}  
void identify()
   {
      printf("Ciezarwka z numerem: %s.\n", plate);
   }
}; 

class Garage {                             // Garaz - parking pietrowy
  int  maxVehicles;                        // pojemnosc parkingu
  Vehicle **parked;                        // tablica wskaznikw do zaparkowanych pojazdw
public:
  Garage(int max);                         // konstruktor: pojemnosc parkingu
  ~Garage();
int accept(Vehicle*);                      // zaakceptuj pojazd
Vehicle *release(int bay);                 // zwolnij zatoczke parkingowa
void  listVehicles();                      // podaj liste zaparkowanych pojazdw
};

Garage::Garage(int max)
{
  maxVehicles = max;
  parked = new Vehicle* [maxVehicles];
  for( int bay = 0; bay < maxVehicles; ++bay)
    parked[bay] = NULL;
}

Garage::~Garage()
{
  delete parked;
}

int Garage::accept(Vehicle *veh)           // wjazd na parking
{
  for( int bay = 0; bay < maxVehicles; ++bay)
     if( !parked[ bay ] )
         {
                parked[ bay ] = veh;
                return bay;
         }       
     return -1;          // nie ma wolnego miejsca na parkingu
}

Vehicle* Garage::release(int bay)          // wyjazd z parkingu
{
  if( bay < 0 || bay >= maxVehicles ) return NULL;
  Vehicle *veh = parked[bay];
  parked[bay] = NULL;
  return veh;
}

void Garage::listVehicles()
{
  for( int bay = 0; bay < maxVehicles; ++bay)
     if(parked[bay])
       {
             printf("Pojazd w zatoczce parkingowej %d to: ", bay);
             parked[bay]->identify();
        }
}

Car c1("RVR 101");
Car c2("SPT 202");
Car c3("CHP 303");
Car c4("BDY 404");
Car c5("BCH 505");

Truck t1("TBL 606");
Truck t2("IKY 707");
Truck t3("FFY 808");
Truck t4("PCS 909");
Truck t5("SLY 000");

int main()
{
    Garage Park(15);
    Park.accept(&c1);
    int  t2bay = Park.accept(&t2);
    
    Park.accept(&c3);
    Park.accept(&t1);
    int c4bay = Park.accept(&c4);

    Park.accept(&c5);
    Park.accept(&t5); 

    Park.release(t2bay);
     
    Park.accept(&t4);
    Park.accept(&t3);

    Park.release(c4bay);
    Park.accept(&c2);

    Park.listVehicles();

    return 0;
}
