#include <stdio.h>

class Component {
  int price_;
  char *name_;
  int rebate_;
public:
	Component( int p, char *n, int r=0);
  int netPrice();
  int price() { return price_; }
  char *name(){ return name_; }
  int rebate(){ return rebate_; } 
};

Component::Component( int p, char *n, int r)
{
  price_ = p;
  name_ = n;
  rebate_ = r;
}

int Component::netPrice()
{
  return price_ - rebate_;
}

class Card : public Component {
public:
  Card(int p, char *n, int r=45) : Component(p, n, r) {}
};

class Monitor : public Component {
public:
  Monitor(int p, char *n, int r=0) : Component(p, n, r) {}
};

Card Network(600, "Karta sieciowa");
Card CDRom(1500, "CDRom");
Card Tape(1000, "Streamer tasmowy");
Monitor Color(1500, "Monitor Kolorowy");
Monitor Monochrome(500, "Monitor Mono");


class Computer {
  Card *card;
  Monitor *mon;
public:
  Computer( Card*, Monitor* );
  int netPrice();
  void print();
};

int Computer::netPrice()
{
  return mon->netPrice() + card->netPrice();
}

Computer::Computer(Card *c, Monitor *m)
{
  card = c;
  mon = m;
}

void Computer::print()
{
  printf("%s %s, cena netto = %d\n", card->name(), 
mon->name(), netPrice());
}

int main()
{
  Computer mn( &Network, &Monochrome );
  Computer mc( &CDRom, &Monochrome );
  Computer mt( &Tape, &Monochrome );
  Computer cn( &Network, &Color );
  Computer cc( &CDRom, &Color );
  Computer ct( &Tape, &Color );

  mn.print();
  mc.print();
  mt.print();
  cn.print();
  cc.print();
  ct.print();

  return 0;
}
