#include <stdio.h>
#include <dirent.h>
#include <errno.h>

class Directory {
  DIR *dir; 
  char  nameCopy[ sizeof(dirent::d_name) ];
  char *errStr;                     // komunikat; NULL = OK
public: 
            Directory(char*);
            ~Directory(); 
const char *name();
          long tell();
          void seek(long);
const char *error();
}; 

Directory::Directory(char *path)
{
  errStr = NULL;                 // zakladamy, ze bledu nie ma
  dir = opendir(path);
  if( !dir ) {
     if( errno > 0 && errno < sys_nerr )
         errStr = (char *) sys_errlist[errno];
     else
          errStr = (char *) "nieznany blad";     // blad, ale nieznany
     errno = 0;
  }
}

Directory::~Directory()
{
  if( dir )
  closedir(dir);
}

const char *Directory::name()
{
  if( dir )
     return NULL;
  dirent *d = readdir(dir);
  if( !d ) return NULL;
  strcpy(nameCopy, d->d_name);
  return nameCopy;
}

long Directory::tell()
{
  return dir ? telldir(dir) : 0;
}

void Directory::seek(long loc)
{
  if( dir )
    seekdir(dir, loc);
}

const char* Directory::error()
{
  return errStr;
}
