#include <stdio.h>
#include <dirent.h>

class Directory
{
  DIR *dir; 
  char  nameCopy[ sizeof(dirent::d_name) ];
public: 
            Directory(char*);
            ~Directory(); 
const char *name();
          long tell();
          void seek(long);
}; 

Directory::Directory(char *path)
{
  dir = opendir(path);
}

Directory::~Directory()
{
  if( dir )
  closedir(dir);
}

const char *Directory::name()
{
  if( !dir )
     return NULL;
  dirent *d = readdir(dir);
  if( !d ) return NULL;
  strcpy(nameCopy, d->d_name);
  return nameCopy;
}

long Directory::tell()
{
  return dir ? telldir(dir) : 0;
}

void Directory::seek(long loc)
{
  if( dir )
    seekdir(dir, loc);
}
