#include <iostream.h>

void trace(const char *funcName, void *objAddr)
{
  cout <<  "\t" << objAddr << " " << funcName << "\n";
}

class Top {
  int x;
public: 
  Top & operator=(const Top &);
};

                                                   // rhs = operand prawostronny
Top & Top::operator=(const Top & rhs)
{
  trace("Top::operator=", this);
  if( this != &rhs )
      x = rhs.x;
  return *this;
}

class Left : public Top 
{
  int y;
public: 
  Left & operator=(const Left &);
};

Left & Left::operator=(const Left & rhs)
{
  trace("Left::operator=", this);
  if( this != &rhs )
     {
      this->Top::operator=( rhs );
      y = rhs.y;
      }
  return *this;
}

class Right : public Top
{
  int z;
public: 
  Right & operator=(const Right &);
};

Right & Right::operator=(const Right & rhs)
{
  trace("Right::operator=", this);
  if( this != &rhs ) {
      this->Top::operator=( rhs );
      z = rhs.z;
  }
  return *this;
}

class Bottom : public Left, public Right {
// ...
};

int main()
{
  Left L1, L2;
  Right R1, R2; 
  Bottom B1, B2; 

  cout << "Przypisanie obiektw klasy Left \n";
  L1 = L2;
  cout << "Przypisanie obiektw klasy Right \n";
  R1 = R2;
  cout << "Przypisanie obiektw klasy Bottom \n";
  B1 = B2;

  return 0;
}
