#include <string.h> 

struct parent 
{
  static char* expression; 
  static int index;
  static int end_state;      // flaga, 1, gdy osiagnieto stan koncowy, inaczej: 0
  static int doom_state;     // 1, jesli nielegalny znak na We, inaczej: 0
  static void reset( char* expr ); 
  virtual parent* transition() {} 
};

void parent::reset( char* expr ) 
{
  expression = new char[ strlen( expr )+1 ];     /
  strcpy( expression, expr );
  end_state = 0	; 
  doom_state = 0; 
  index = 0; 
}

struct state1 : public parent                
{
  parent* transition();                         
};

// ...

struct state5 : public parent                
{
  parent* transition();                         
};

char* parent::expression = NULL;
int parent::doom_state = 0;
int parent::end_state = 0;
int parent::index = 0;

state1 s1;   
state2 s2;
state3 s3;
state4 s4;
state5 s5;

parent* state1::transition() 
{
    switch( expression[ index++ ] )
      {
         case 'A':  return &s2;
         case 'B':  return &s3;
         case 'C':  return &s4;
         case 'D':  return &s5;
         case '\0':  doom_state = 1;
         default: doom_state = 1;                  
       }
}

// ...

parent* state5::transition() 
{
    switch( expression[ index++ ] )
      {
         case 'O':  return &s2;
         case 'H':  return &s5;
         case 'L':  end_state = 1; break;
         case 'N':  return &s4;
         case '\0':  doom_state = 1;
         default: doom_state = 1;                  
       }
}

#include <stdio.h>

main()
{
  char input_string[80];           // wejsciowy lancuch znakw
  printf("Wpisz wyrazenie wejsciowe: ");
  scanf("%s", input_string); 
  parent::reset(input_string);
  parent *ptr;
  ptr = s1.transition();
  while( ptr->end_state != 1 && ptr->doom_state != 1 )
  {
     ptr = ptr->transition();
  }
  if( ptr->end_state == 1 )
     printf("\nPoprawne wyrazenie wejsciowe.");
  else
     printf("\nNieprawidlowe wyrazenie wejsciowe.");
  return 0;
}
