#include <iostream.h>
#include <string.h>
#include <stdlib.h>


class string
{
private:			// specyfikator przyjmowany domyslnie (mozna pominac)
  struct srep {			// zagniezdzona struktura - serwer
    char *s;                    // wskaznik do danych
    int n;			// licznik
  srep() { n = 1; }		// domyslny konstruktor struktury
  };
  srep *p;			// wskaznik do struktur typu 'srep'
public:
  string();			// k. domyslny; deklaracja typu: 'string X;'
  string(const char*);		// k. konwersji; deklaracja 'string X("abc");'
  string(const string&);	// k. kopiujacy; wyrazenia typu: 'string X = string-object;'
  ~string();			// destruktor
			// teraz operatory:
  string& operator=(const char*);	// string X = "stala typu string";
  string& operator=(const string&); 	// string X = Y;
  char&   operator[]( int i );
			// operatory zaprzyjanione
  friend ostream& operator << (ostream&, const string&);
  friend istream& operator >> (istream&, string&);

  friend int operator==(const string &x, const char *s)
    { return strcmp(x.p->s, s) == 0; }
  friend int operator==(const string &x, const string &y)
    { return strcmp(x.p->s, y.p->s) == 0; }
  friend int operator!=(const string &x, const char *s)
    { return strcmp(x.p->s, s) != 0; }
  friend int operator!=(const string &x, const string &y)
    { return strcmp(x.p->s, y.p->s) != 0; }
};

string::string()
{
  p = new srep;			// konstruktor dynamicznie tworzy strukture
  p->s = 0;                     // inicjujemy wskaznik jako pusty
}

string::string(const string& x)
{
  x.p->n++;			// inkrementujemy licznik
  p = x.p;
}


string::string(const char *s)
{
  p = new srep;
  p->s = new char[ strlen(s)+1 ];
  strcpy( p->s, s );
}

string::~string()
{
  if( --p->n == 0 )
    {
      delete p->s;
      delete p;
    }
}

string& string::operator=(const char* s)
{
  if( p->n > 1 )	// warunek "odlaczenia" - "self disconnect"
   {
     p->n--;
     p = new srep;
   }
  else delete p->s;	// albo zwolnij pamiec po "starym tekscie"

  p->s = new char[ strlen(s)+1 ];
  strcpy(p->s, s);
  return *this;
}

string& string::operator=(const string& x)
{
  x.p->n++;		// ochrona przed sytuacja typu X = X
  if( --p->n == 0 )
   {
     delete p->s;
     delete p;
   }
  p = x.p;
  return *this;
}

ostream& operator << (ostream& s, const string& x)
{
  return s << x.p->s << '\n';
}

istream& operator >> (istream& s, string& x)
{
  char bufor[256];	// bufor na wczytywany lancuch znakow
  s >> bufor;		// niebezpieczne, moze wystapic przepelnienie bufora
  x = bufor;
  return s;
}

char& string::operator[]( int i )
{
  if( i<0 || strlen(p->s)<i ) abort();
  return p->s[i];
}


// Program glowny (klienta) stanowi prosty sterownik
// wczytujacy znaki i wyprowadzajacy na ekran jak 'ECHO'
// po zakonczeniu wprowadzania slowa zostaja wyprowadzone
// w odwrpotnej kolejnosci.

int main()
{
  string x[100];		// deklarujemy obiekt
  int n;			// i zwykla zmienna

  cout << "Zaczynamy. \n";
  for(n=0; cin >> x[n]; n++) {	// STOP po wpisaniu "koniec"
   if(n==100) abort();
    string y;
    cout << (y = x[n]);
   if(y=="koniec") break;
   }
  cout << "i oto wrocilismy do poczatku. \n";
  for(int i = n-1; i>=0; i++) cout << x[i];
return 0;
}