/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E S H A P R P . H                         //
//                                                            //
//         Interfejs klasy ShapeRep.                          //
//                                                            //
//************************************************************//

#define _SHAPEREP_H
#ifndef _SHAPE_H
#include "eshape.h"
#endif
#ifndef _COORDINATE_H
#include "ecoord.h"
#endif

class ShapeRep: public Thing {
public:
    /* deklaracje wszystkich operatorw definiowanych przez 
     * uytkownika powinny znale si w tym miejscu.
     * Ze wzgldu na zastosowanie operatora ->
     * sygnatura tej klasy nie musi by powielana w klasie Shape.
     * Jednak naley pamita, aby skadowa rep klasy
     * Shape bya waciwego typu.
     * Operator przypisania definiowany jest w klasie Shape.
     *
     * typ return_type zwracany przez deklarowane tutaj funkcje uytkownika powinien
     * by typem podstawowym, typem Shape, typem Shape&
     * lub konkretnym typem danych
     */
    virtual void rotate(double);
    virtual void move(Coordinate);
    virtual void draw();
    virtual void erase();

    // konstruktory
    Shape make(Coordinate,Thingp);
    Shape make(Coordinate,Coordinate,Thingp);
    Shape make(Coordinate,Coordinate,Coordinate,Thingp);

    // ponisze funkcje s przesaniane w klasach pochodnych;
    // ich domylne dziaanie polega na wywoaniu
    // funkcji wymienionych powyej dla domynej wartoci
    // parametru Thingp 
    virtual Shape make();
    virtual Shape make(Coordinate);
    virtual Shape make(Coordinate,Coordinate);
    virtual Shape make(Coordinate,Coordinate,Coordinate);

    // funkcja zaznaczania obiektu
    // przez algorytm Bakera 
    virtual void mark();

    // zwraca wskanik odpowiedniego przykadu
    Thing *type();

    // Odzyskiwanie nieuytkw.  Jeli parametr rwny jest zero,
    // to zamiata biec pul; jeli rny od zera, to tworzy now 
    // pul umoliwiajc przechowywanie obiektw o podanym
    // rozmiarze
    virtual void gc(size_t = 0);

    // konstruktory klasy
    ShapeRep();
    ~ShapeRep();
    ShapeRep(Exemplar);

    // okrela porzdek inicjacji
    // statycznych danych klasy
    static void init();
protected:
    friend class Shape;
    Coordinate center;

    // przykad reprezentuje typ obiektw
    Top *exemplarPointer;

    // zmienne stanu zarzdzania pamici:  Space
    // oznacza moe przyjmowa warto FromSpace 
    // lub ToSpace; gcmark jest znacznikiem 
    // obiektw w algorytmie Bakera;  inUse
    // oznacza, e obiekt zosta przekazany uytkownikowi
    unsigned char space:1, gcmark:1, inUse:1;
protected:
    // wsplne funkcje wykorzystywane w fazie zamiatania
    // przez odzyskiwanie nieuytkw bazujce na algorytmie Bakera 
    static void gcCommon(size_t nbytes,
        const size_t poolInitialized,
        const int PoolSize, Char_p &h);

    // Ponisze dwie "stae" oznaczaj przestrze rdow
    // i docelow w algorytmie Bakera. Przestrzenie te s
    // zamieniane z kadym przebiegiem algorytmu
    static unsigned char FromSpace, ToSpace;

    // oglne operatory zarzdzania pamici, korzystajce
    // z puli na ktrej dziaa funkcja gc
    static void *operator new(size_t);
    static void operator delete(void *);

    // obiekt bez typu uywany jako domylna warto zwracana
    static Shape *aShape;
};

