/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E R E C T . C                             //
//                                                            //
//         Implementacja klasy Rectangle                      //
//                                                            //
//************************************************************//

#include "erect.h"

ShapeRep *rectangle = 0;      // przykad klasy Rectangle

void
Rectangle::init() {
    // inicjuje zmienne statyczne i globalne specyficzne dla klasy Rectangle.
    // Inicjacja struktur danych wykonywana jest podczas pierwszego
    // wywoania funkcji ShapeRep::gcCommon 
    rectangle = new Rectangle(Exemplar(0));
}

Shape
Rectangle::make()
{
    // tworzy domylny prostokt
    Rectangle *retval = new Rectangle;
    retval->p1 = retval->p2 = Coordinate(0,0);
    retval->exemplarPointer = this;
    return *retval;
}

Shape
Rectangle::make(Coordinate pp1, Coordinate pp2)
{
    // create a rectangle at a specified place
    Rectangle *retval = new Rectangle;
    retval->p1 = pp1;
    retval->p2 = pp2;
    retval->exemplarPointer = this;
    return *retval;
}

void
Rectangle::draw() {
    int Sizeof = poolInitialized? poolInitialized:
        sizeof(Rectangle);
    printf("<obiekt klasy Rectangle %c>",
        'A' + (((char *)this-(char *)heap)/Sizeof));
}

void
Rectangle::move(Coordinate) {
    // . . .
}

void
Rectangle::rotate(double) {
    // . . .
}

//************************************************************//
//                 Zarzdzanie pamici                       //
//************************************************************//

char *Rectangle::heap = 0;             // pula dla operatora new
size_t Rectangle::poolInitialized = 0; // rozmiar obiektu klasy Rectangle

void
Rectangle::gc(size_t nbytes) {
    // do garbage collection on Rectangle instances
    printf("Wywoanie Rectangle::gc(%d)\n", nbytes);
    gcCommon(nbytes, poolInitialized, PoolSize, heap);
}

void *
Rectangle::operator new(size_t nbytes) {
    // dynamicznie przydziela pami dla obiektu Rectangle
    if (poolInitialized - nbytes) {
        gcCommon(nbytes, poolInitialized, PoolSize, heap);
        poolInitialized = nbytes;
    }
    Rectangle *tp = (Rectangle *)heap;
    // tutaj naleaoby sprawdza, czy pula nie zostaa zuyta
    while (tp->inUse) {
        tp = (Rectangle*)(((char*)tp) + Round(nbytes));
    }
    tp->gcmark = 0;
    tp->inUse = 1;
    return (void*) tp;
}

void Rectangle::operator delete(void *) {
    // bez operacji -- patrz Rectangle::gc powyej
}

Rectangle::Rectangle() {
    // ze wzgldu na "skadow" vptr i rozmiar obiektu
}

Rectangle::Rectangle(const Rectangle& t) {
    // konstruktor kopiujcy
    p1 = t.p1;
    p2 = t.p2;
}

Rectangle::Rectangle(Exemplar e) : ShapeRep(e) {
    // konstruktor tworzcy przykad
}

