/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//      P L I K :   E K . H                                   //
//                                                            //
//         Deklaracje klas Thing and Top                      //
//                                                            //
//************************************************************//

#ifndef _MPTR_H
#include "emptr.h"
#endif

#define _K_H
#include <String.h>

//  MACHINE AND COMPILER DEPENDENT
const unsigned int WRDSIZE = sizeof(void*);

inline size_t
Round(size_t s) {
    return (size_t)((s + WRDSIZE - 1)/WRDSIZE)*WRDSIZE;
}

// czsto wykorzystywany typ wskanika
typedef char *Char_p;

// typ uywany jedynie w celu rozrnienia
// konstruktorw klas pochodnych klasy ShapeRep 
enum Exemplar { };

//  KOD ZALENY OD PLATFORMY I KOMPILATORA

class Top {
public:
    // Klasa nie posiada danych oprcz pola __vtbl 
    // generowanego przez kompilator.  Obiekty wszystkich 
    // klas pochodnych klasy Top bd posiada skadow __vtbl
    // jako swj pierwszy element.
    // Jeli nie jest to prawd dla uywanego kompilatora
    // to konieczne bdzie zastosowanie innego mechanizmu
    // odnajdywania wartoci __vtbl i implementacja
    // moe by nieco inna.

    virtual ~Top() { }
    mptr* findVtblEntry(vptp);
    void update(String, String, const char *const = "");
    static void operator delete(void *p) {
        ::operator delete(p);
    }
    // doit jest funkcj pomocnicz oglnego przeznaczenia
    // zwizan z aktualizacj
    virtual Top *doit();
protected:
    Top()  { }
    static void *operator new(size_t l) {
        return ::operator new(l);
    }
private:
    // porwnuje dwa wskaniki funkcji
    int compareFuncs(int, vptp, vptp);
};

typedef Top *Topp;

class Thing: public Top {
    // wszystkie pola "rep" s dziedziczone po klasie Thing;  
    // definiuje posta kanoniczn dla wszystkich klas listu
public:
    virtual Thing *type() { return this; }
    Thing() { }
    virtual Thing *cutover();       // funkcja aktualizacji pola klasy
    virtual ~Thing() { }            // destruktor
    int docutover();
};

typedef Thing *Thingp;

