/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

class Letter: public Thing {
public:
    /* deklaracje wszystkich operatorw definiowanych przez 
     * uytkownika powinny znale si w tym miejscu.
     * Ze wzgldu na zastosowanie operatora ->
     * sygnatura tej klasy nie musi by powielana w klasie Envelope.
     * Jednak naley pamita, aby skadowa rep klasy
     * Envelope bya waciwego typu.
     * Operator przypisania definiowany jest w klasie Envelope.
     *
     * typ return_type zwracany przez deklarowane tutaj funkcje uytkownika powinien
     * by typem podstawowym, typem Envelope, typem Envelope&
     * lub konkretnym typem danych
     */
    virtual void send(String name, String address);
    virtual double postage();
    virtual return_type funkcja_uytkownika;
    . . . .
    virtual Envelope make();          // konstruktor
    virtual Envelope make(double);    // kolejny konstruktor
    virtual Envelope make(int days, double weight);
    virtual Thing *cutover(Thing*);  // funkcja aktualizacji podczas wykonania
    Letter() { }
    ~Letter() { }
    Thing *type();
protected:
    friend class Envelope;
    double ounces;
    static void *operator new(size_t l) {
        return ::operator new(l);
    }
    static void operator delete(void *p) {
        ::operator delete(p);
    }
    String name, address;
    . . . .
private:
    . . . .
};

