/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

#include "k.h"       // z poprzedniego listingu

#include "9-3.h"     // funkcje skdowe klasy Envelope 

extern Thing *envelope, *letter; // wskaniki przykadw

class Envelope: public Top {     // klasa Top zdefiniowana w k.h
public:
    Letter *operator->() const { // przekazuje wszystkie operacje
        return rep;              // obiektowi rep
    }
    Envelope()    { rep = letter->make(); }
    Envelope(Letter&);
    ~Envelope() {
        if (rep && rep->deref() <= 0) delete rep;
    }
    Envelope(Envelope& x) {
        (rep = x.rep)->ref();
    }
    Envelope& operator=(Envelope& x) {
        if (rep != x.rep) {
            if (rep && rep->deref() <= 0) delete rep;
            (rep = x.rep)->ref();
        }
        return *this;
    }
    Thing *type() { return envelope; }
private:
    static void *operator new(size_t) {
        Sys_Error("heap Envelope");
    }
    static void operator delete(void *) { }
    Letter *rep;
};

