/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

class String {
public:
    // publiczny interfejs klasy String:

    // zmienia definicj operatora "+", 
    // ktry oznacza bdzie konkatenacj acuchw, 
    // istniej dwa jej przypadki:
    friend String operator+(const char*, const String&);
    String operator+(const String&) const;
    int length() const;      // dugo acucha
    // . . . .               // inne operacje

    // funkcje skadowe specjalnego przeznaczenia:

    String();                // konstruktor domylny
    String(const String&);   // konstruktor inicjujcy 
                             //   acuch na podstawie zawartoci ju istniejcego acucha
    String& operator=(const String&);  // przypisanie
    ~String();               // destruktor

    /*
     * Operatory te s typowe w przypadku definiowania
     * specyficznego zachowania typu.  Zamieszczone tutaj
     * przykady s odpowiednie dla klasy String.
     */

    String(const char *);    // inicjuje acuch na podstawie acucha 
                             // charakterystycznego dla jzyka C
private:
    char *rep;               // dane implementacji
                             //    i funkcje wykorzystywane wewntrznie
                             //    (tutaj jedynie reprezentacja acucha
                             //    w sposb charakterystyczny dla jzyka C)

};

