/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    eshaprp.c                                 //
//                                                            //
//         Kod klasy ShapeRep                                 //
//                                                            //
//************************************************************//

// ShapeRep jest klas bazow dla wszystkich klas listu, 
// dla ktrych klasa Shape jest kopert.  W klasach pochodnych
// klasy ShapeRep znajduje si caa logika zwizana z reprezentacj
// figur geometrycznych

#include "eshaprp.h"
#ifndef _RECTANGLE_H
#include "erect.h"
#endif
#ifndef _TRIANGLE_H
#include "etringl.h"
#endif

// "staa" uywana jako "zdegenerowana" warto zwracana
Shape *ShapeRep::aShape = 0;

// bity oznaczajce przestrze rdow i docelow algorytmu Bakera;
// przestrzenie te s zamieniane z kadym cyklem algorytmu
unsigned char ShapeRep::FromSpace = 0, ShapeRep::ToSpace = 1;

void ShapeRep::init() {
    // inicjuje struktury danych klasy
    aShape = new Shape;
}

void *
ShapeRep::operator new(size_t l) {
    // przesonita w funkcjach pochodnych
    return ::operator new(l);
}

void
ShapeRep::operator delete(void *p) {
    // przesonita w funkcjach pochodnych
    ::operator delete(p);
}

Thing *
ShapeRep::type() {
    // typ dowolnej klasy pochodnej
    // klasy ShapeRep reprezentowany jest przez exemplarPointer
    return (Thingp)exemplarPointer;
}

Shape
ShapeRep::make() {
    // domylny producent obiektw ShapeRep 
    return *aShape;
}

Shape
ShapeRep::make(Coordinate c1, Thingp) {
    // jeden parametr: tworzy obiekt klasy Point
    return point->make(c1);
}

Shape
ShapeRep::make(Coordinate c1, Coordinate c2, Thingp type) {
    // konstruktor obiektw figur reprezentowanych przez dwa wierzchoki
    // czyli obiektw klas Line i Rectangle
    return ((ShapeRep *)type)->make(c1, c2);
}

Shape
ShapeRep::make(Coordinate c1, Coordinate c2, Coordinate c3,
           Thingp type) {
    // konstruktor obiektw figur reprezentowanych przez trzy wierzchoki
    // czyli obiektw klas Triangle, Arc, Parallelogram
    return ((ShapeRep*)type)->make(c1, c2, c3);
}

Shape
ShapeRep::make(Coordinate c1) {
    // tworzy figur reprezentowan przez jeden wierzchoek
    // domylnie zwraca obiekt klasy Point
    return make(c1, (Thingp)&point);
}

Shape
ShapeRep::make(Coordinate c1, Coordinate c2) {
    // tworzy figur reprezentowan przez dwa wierzchoki
    // domylnie zwraca obiekt klasy Rectangle
    return make(c1, c2, rectangle);
}

Shape
ShapeRep::make(Coordinate c1, Coordinate c2, Coordinate c3) {
    // tworzy figur reprezentowan przez trzy wierzchoki
    // domylnie zwraca obiekt klasy Triangle
    return make(c1, c2, c3, triangle);
}

void
ShapeRep::gcCommon(size_t nbytes, const size_t poolInitialized,
        const int PoolSize, Char_p &heap) {
    // Mechanizm odzyskiwania nieuytkw wsplny dla wszystkich
    // klas pochodnych klasy ShapeReps.  
    // Wykonuje wiksz cz zamiatania w drugiej fazie 
    // algorytmu Bakera.  Funkcja ta wywoywana jest 
    // bezporednio przez funkcje gc klas pochodnych, ktre
    // przekazuj jej odpowiednie parametry.

    // Wyznacza rozmiar obiektu oznaczony jako s 
    // Uywa wartoci nbytes jeli zostaa wyspecyfikowana.
    // Oznacza ona zmian rozmiaru lub uywana jest podczas inicjacji.
    // W przeciwnym razie uywa wartoci przechowywanej
    // przez poolInitialized.
    size_t s = nbytes? nbytes: poolInitialized;

    // zaokrgla ze wzgldu na ograniczenia
    // zwizane z wyrwnaniem w pamici
    size_t Sizeof = Round(s);

    // Jeli paramater ma warto rn od zera, 
    // to reprezentuje rozmiar obiektu.
    // Oznacza to, e usuwamy star pul
    // i tworzymy now. 
    // Operacja ta wykonywana jest podczas uruchomienia
    // oraz po aktualizacji klasy.
    if (nbytes) heap = new char[PoolSize * Sizeof];

    ShapeRep *tp = (ShapeRep *)heap;

    // zamiata pul
    for (int i = 0; i < PoolSize; i++) {
        switch (nbytes) {
        case 0:   // zwyky przypadek odzyskiwania nieuytkw
            // jeli obiekt posiada ustawiony znacznik wykorzystania,
            // ale nie posiada ustawionego znacznika algorytmu Bakera
            // i naley przy tym do przestrzeni rdowej,
            // to zostanie zwolniony.
            if (tp->inUse) {
                if (tp->gcmark || tp->space != FromSpace) {
                    // nie zamiata obiektu
                    tp->space = ToSpace;
                } else if (tp != tp->type()) {
                    // pami obiektu bdzie odzyskana
                    tp->ShapeRep::~ShapeRep();
                    tp->inUse = 0;
                    printf("ShapeRep::gcCommon ");
                    printf("Odzyskana pami obiektu %c\n",
                     'A' + (((char *)tp-(char *)heap)/Sizeof));
                }
            }
            break;
        default:   // inicjacja puli
            tp->inUse = 0;
            break;
        }
        tp->gcmark = 0;
        tp = (ShapeRep*)(Char_p(tp) + Sizeof);
    }
}

ShapeRep::ShapeRep(Exemplar) {
    // konstruktor tworzcy przykad klasy ShapeRep
    // (niezbyt istotny)
    //
    // Przypomnijmy, e Exemplar jest fikcyjnym typem
    // sucym jedynie odrnieniu tego konstruktora
    // od konstruktora domylnego
    exemplarPointer = this;
    shape->Register(this);
}

void
ShapeRep::rotate(double) {
    // dziaa jak funkcja czysto wirtualna
    printf("ShapeRep::rotate(double)\n");
}

void
ShapeRep::move(Coordinate) {
    // dziaa jak funkcja czysto wirtualna
    printf("ShapeRep::move(Coordinate)\n");
}

void
ShapeRep::draw() {
    // dziaa jak funkcja czysto wirtualna;
    // funkcje rysowania figur bd wywietla
    // jedynie nazw klasy figury
    printf("<Shape>");
}

void
ShapeRep::erase() {
    // dziaa jak funkcja czysto wirtualna
    printf("ShapeRep::erase()");
}

void
ShapeRep::gc(size_t) {
    // dziaa jak funkcja czysto wirtualna
}

void
ShapeRep::mark() {
    // wykorzystywana przez klas Shape 
    // w fazie zaznaczania algorytmu Bakera
    gcmark = 1;
}

ShapeRep::ShapeRep() {
    // konstruktor domylny
    exemplarPointer=this;
    gcmark=0;
    space=ToSpace;
    inUse=1;
}

ShapeRep::~ShapeRep() {
    // destruktor nie wykonuje adnych operacji
}

