/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

#include "3-14.h"

String *String::newlist = 0;

void String::operator delete(void *p) {
    String *s = (String *)p;
    s->freepointer = newlist;
    newlist = s;
}

void* String::operator new(size_t size) {
    if (size != sizeof(String)) {
        // sprawdzenie tego warunku jest konieczne ze 
        // wzgldu na sytuacje, w ktrych klasa pochodna
        // (patrz rozdzia 4) nie posiada wasnego operatora new. 
        // Przedstawiony wyej String::operator delete 
        // odzyska ten "przeronity" blok po zwolnieniu obiektu.
        return malloc(size);
    } else if (!newlist) {
        newlist = (String *)new char[100 * sizeof(String)];
        for (int i = 0; i < 99; i++) {
            newlist[i].freepointer = &(newlist[i+1]);
        }
        newlist[i].freepointer =0;
    }
    String *savenew = newlist;
    newlist = newlist->freepointer;
    return savenew;
}

