/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

// stddef.h (korzystamy z size_t)
#include <stddef.h>

#define HEAP_BASE_ADDRESS 0x001000;

struct Head {
   long length;
   struct Head *next;
};

static Head pool = { 0, 0 };

static Head *h = (Head *)HEAP_BASE_ADDRESS;

/* szybki przydzia pamici na zasadzie "pierwszy pasujcy" */

typedef char *Char_p;

// PONISZY WIERSZ ZALENY JEST OD PLATFORMY I KOMPILATORA:
const long WRDSIZE = sizeof(void*);

void* operator new(size_t nbytes)
{
    /* Przegldanie listy wolnych blokw */
    if (pool.next) {
        Head *prev = &pool;
        for (Head *cur = &pool; cur; cur = cur->next) {
            if (cur->length >= nbytes) {
                prev->next = cur->next;
                return (void*)(Char_p(cur) + sizeof(Head));
            } else prev = cur;
        }
    }
    /* Jeli nie pasowao nic z listy, to pobiera nowy blok ze sterty  */
    h = (Head*)(((int)((Char_p(h)+WRDSIZE-1))/WRDSIZE)*WRDSIZE);
    h->next = 0;
    h->length = nbytes;
    h += nbytes + sizeof(Head);
    return (void*)(Char_p(h) + sizeof(Head));
}

void operator delete(void *ptr)
{
    Head *p = (Head *)(Char_p(ptr) - sizeof(Head));
    p->next = pool.next;
    pool.next = p;
}

