/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E S H A P E . C                           //
//                                                            //
//         Kod klasy Shape                                    //
//                                                            //
//************************************************************//

#include "eshape.h"
#ifndef _SHAPEREP_H
#include "eshaprp.h"
#endif
#ifndef _TRIANGLE_H
#include "etringl.h"
#endif
#ifndef _RECTANGLE_H
#include "erect.h"
#endif
#include "List.h"

// Klasa Shape wykonuje wikszo zada zwizanych
// z zarzdzaniem pamici obiektw nalecych do jej 
// hierarchii.

// Uchwyty instancji Shape 
List<Topp> *Shape::allShapes = 0;

// Lista wszystkich przykadw
// klas pochodnych klasy ShapeRep
List<Thingp> *Shape::allShapeExemplars = 0;

// przykad klasy Shape
extern Shape *shape = 0;

void
Shape::init() {
    // inicjuje globalne struktury danych wykorzystywane
    // przez klasy reprezentujce figury, dziki czemu
    // funkcja main moe okreli waciwy porzdek inicjacji
    allShapes = new List<Topp>;
    allShapeExemplars = new List<Thingp>;
    shape = new Shape;

    // organizuje porzdek inicjacji klas pochodnych klasy ShapeRep
    ShapeRep::init();
    Triangle::init();
    Rectangle::init();
}

Top *
Shape::doit() {
    // funkcja pomocnicza,
    // moe by dowolnie wykorzystana przez uytkownika
    return 0;
}

Shape::Shape() {
    // konstruktor domylny
    Topp tp = this;

    // rejestruje si na licie allShapes
    allShapes->put(tp);

    // na razie nie znamy 
    // docelowego rodzaju figury
    rep = new ShapeRep;
}

Shape::~Shape() {
    Listiter<Topp> tp = *allShapes;
    Topp t;
    for ( tp.reset(); tp.next(t); ) {
        if (t == (Thingp)this) {
            tp.remove_prev(t);
            break;
        }
    }
    if (allShapes->length() == 0) {
        // odzyskiwanie nieuytkw
        gc();
    }
}

Shape::Shape(Shape &x) {
    // konstruktor kopiujcy
    Thingp tp = (Thingp) this;

    // rejestruje si na licie allShapes
    allShapes->put(tp);

    // zgodnie z parametrem
    rep = x.rep;
}

Shape::Shape(ShapeRep &x) {
    // tworzy obiekt Shape na podstawie obiektu ShapeRep:  
    // zadaniem tego konstruktora jest gwnie
    // konwersja obiektw klas
    // Triangle, Rectangle, etc. na obiekty 
    // klasy Shape zwracane uytkownikowi
    // (wewntrzne obiekty reprezentacji nie s
    // widoczne dla uytkownika)
    Topp tp = this;

    // rejestruje si na licie allShapes
    allShapes->put(tp);

    // uwaga:  nie mona uy ->ref();  
    // uytkownik musi uzyska kopi!
    rep = &x;
}

Shape&
Shape::operator=(Shape &x) {
    // Przypisanie figur.  Nie musimy martwi
    // si obiektem wskazywanym przez rep. 
    // Zajmie si nim mechanizm odzyskiwania
    // nieuytkw.
    rep = x.rep;
    return *this;
}

Top *
Shape::type() {
    // typem obiektu klasy Shape jest jej przykad
    return shape;
}

void
Shape::dataUpdate(Thingp &oldExemplar,
                               const Thingp newExemplar) {
    // Funkcja umoliwiajca zastpienie klasy pochodnej
    // klasy ShapeRep.  Zakada, e wszystkie funkcje wirtualne
    // tej klasy zostay pnownie skompilowane i zaadowane
    // przyrostowo zgodnie z now definicj klasy.  Przyjmuje 
    // rwnie, e programista dostarczy funkcji cutover,
    // ktra wywoana dla instancji starego formatu zwrci
    // wskanik rwnowanej jej semantycznie kopii.
  
    ShapeRep* savedExemplar = (ShapeRep*) oldExemplar;
    Topp tp = 0;

    // modyfikacje wykonywane s na kopii,
    // ktra zostanie uyta na zakoczenie tej
    // funkcji skadowej.

    List<Topp> staticCopy = *allShapes;

    // zmienia przykad
    oldExemplar = newExemplar;

    // przeksztaca wszystkie podobiekty danego przykadu
    Listiter<Topp> shapeIter = staticCopy;
    for ( shapeIter.reset(); shapeIter.next(tp);  ) {
        Shapepointer sp = (Shapepointer)tp;
        if (sp->rep->type() == (Thingp)savedExemplar) {
            if (sp->rep->docutover()) {
                ShapeRep *oldrep = sp->rep;
                printf("\tkonwersja figury 0x%x do nowego formatu\n",
                    oldrep);
                sp->rep = (ShapeRep*)sp->rep->cutover();

                // konieczne rczne zwolnienie obiektu rep:
                // nie zostanie on obsuony przez mechanizm
                // odzyskiwania uytkw, poniewa znajdziesi
                // poza zakresem jego dziaania
                oldrep->ShapeRep::~ShapeRep();
            }
        }
    }

    // Usuwa przykad z listy wszystkich przykadw 
    // przestajc by tym samym czci 
    // abstrakcyjnego przykdu bazowego
    UnRegister(savedExemplar);
}

void
Shape::gc() {
    // funkcja odzyskiwania nieuytkw: przywraca
    // pami nieosigalnych ju obiektw klas pochodnych
    // klasy ShapeRep.  Uzywa algorytmu Bakera.

    // Pierwsza faza algorytmu Bakera:  zaznacza osigalne obiekty
    Listiter<Topp> shapeIter = *allShapes;
    shapeIter.reset();
    for ( Topp tp = 0; shapeIter.next(tp);  ) {
        Shapepointer sp = (Shapepointer)tp;
        if (sp->rep) {
            sp->rep->mark();
        }
    }        

    // Pierwsza faza algorytmu Bakera:  zamiatanie.  Umoliwia
    // poszczeglnym podtypom zamiatanie wasnych puli za pomoc
    // ich wasnych funkcji skadowych gc.
    Listiter<Thingp> shapeExemplarIter = *allShapeExemplars;
    shapeExemplarIter.reset();
    for ( Thingp anExemplar = 0;
                shapeExemplarIter.next(anExemplar);  ) {
        ShapeRep *thisExemplar = (ShapeRep*)anExemplar;
        thisExemplar->gc(0);
    }

    // Zamiana przestrzeni rdowej i docelowej algorytmu Bakera
    ShapeRep::FromSpace ^= 1;
    ShapeRep::ToSpace ^= 1;
}

void
Shape::Register(ShapeRep *s) {
    // funkcja, za pomoc ktrej rejestruj
    // si przykady klas pochodnych klasy ShapeRep 
    Thingp tp = s;
    allShapeExemplars->put(tp);
}

void
Shape::UnRegister(ShapeRep *s) {
    // Umoliwia wyrejestrowanie si przykadu.
    // (gdy zastpowany jest now wersj)
    Thingp tp = 0;
    Listiter<Thingp> shapeIter = *allShapeExemplars;
    for ( shapeIter.reset(); shapeIter.next(tp); ) {
        if (tp == (Thingp)s) {
            shapeIter.remove_prev(tp);
        }
    }
}

