/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :     L O A D . C                              //
//                                                            //
//         Kod funkcji adujcej w jzyku C                   //
//                                                            //
//************************************************************//

#include <a.out.h>
#include <fcntl.h>
#include "emptr.h"
#include "String.h"

static String symtab;
static char y = 'a';

extern "C" vptp load(const char *filename) {
    // Funkcja load dokonuje najpierw konsolidacji 
    // podanego pliku do pliku a.out
    // wykorzystujc poprzedni zawarto pliku a.out 
    // w celu rozwizania referencji symboli.
    // Nastpnie ustala rozmiary blokw
    // .text i .data sizes i wczytuje je do nowo przydzielonego
    // bloku pamici.  Funkcja ta umoliwia dynamiczne
    // adowanie kodu i zaprojektowana zostaa do 
    // wsppracy z zewntrznym konsolidatorem posiadajcym
    // moliwo pracy przyrostowej.  

    int errcode = 0;
    String newfile;
    char buf[256];
    long adx, oadx;
    unsigned char *ldadx;
    struct exec Exec;
    int fd, wc;

    // Za pierwszym razem korzysta z wartoci domylnych.
    // Plik a.out jest rdem tabeli symboli.  Za kadym 
    // razem, gdy wykonywane jest adowanie przyrostowe, 
    // zmie nazw pliku tworzonego przez konsolidator, a pniej 
    // usu stare pliki.


    if (!symtab.length()) {
        symtab = "a.out"; newfile = "b.out";
    } else {
        symtab = String(++y) + ".out";
        newfile = String(y+1) + ".out";
    }

    // znajduje grn granic pamici
    // i wyrwnuje j
    oadx = (long)sbrk(0);
    adx = oadx + PAGSIZ - (oadx%PAGSIZ);

    // wykonuje przyrostow konsolidacj
    // dostarczonego pliku wynikowego .o 
    // na podstawie biecego pliku a.out
    // 
    sprintf(buf, "ld -N -Ttext %X -A %s %s -o %s",
        adx, (const char*)symtab, filename,
        (const char*)newfile);
    printf("<%s>\n", buf);
    if ((errcode=system(buf)) != 0) {
        printf("load: konsolidator zwrci kod bdu: %d\n",
            errcode);
    }
    if (symtab != "a.out") unlink(symtab);

    // otwiera plik i aduje jego zawarto do pamici
    fd = open(newfile, O_RDONLY);
    if (fd < 0) {
        printf("load: otwarcie pliku \"%s\" nie powiodo si\n", newfile);
        return 0;
    }

    // odczytuje nagwek pliku relokowalnego,
    // aby ustali rozmiary obszarw .text i .data
    read(fd, (char *)&Exec, sizeof(struct exec));

    // wyrwnuje granic pamici i przydziela pami
    // dla nowego kodu
    sbrk(int(PAGSIZ-(oadx%PAGSIZ)));
    ldadx = (unsigned char *)
        sbrk(int(Exec.a_text + Exec.a_data + Exec.a_bss));

    // wczytuje zawarto pliku do biecego procesu
    // pod wyliczony poniej adres
    wc = read(fd, (char *)ldadx,
	int(Exec.a_text + Exec.a_data));
    close(fd);

    // zwraca adres adowania
    return (vptp) ldadx;
}

