/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E T O P . C                               //
//                                                            //
//         Implementacja klasy Top                            //
//                                                            //
//************************************************************//

#include "ek.h"
#include <sys/types.h>

Top *
Top::doit() {
    // niewykorzystywana funkcja umoliwiajca
    // uytkownikowi zarzdzanie aktualizacj klasy
    return 0;
}

int
Top::compareFuncs(int vtblindex, vptp, vptp fptr) {
    // Porwnuje dwa wskaniki funkcji
    // Pierwszy z nich scharakteryzowany jest
    // przez indeks pozycji w tablicy vbtl i wskanik
    // funkcji, a drugi jedynie za pomoc wskanika funkcji.
    // Sposb uycia parametrw funkcji zaley do konkretnej platformy;
    // W tym przypadku pierwszy ze wskanikw nie jest wykorzystywany.
    return vtblindex == (int)fptr;
}

mptr *
Top::findVtblEntry(vptp f) {
    // Poszukuje w tablicy funkcji wirtualnych danego obiektu
    // (wskazywanego przez this) wskanika funkcji 
    // rwnego parametrowi f i zwraca adres zawierajcej
    // go struktury mptr (czyli elementu tablicy funkcji wirtualnych)

    // mpp bdzie adresem wskanika vtbl; 
    // struktura dziedziczenia gwarantuje nam, e wskanik
    // vtbl znajduje si na pocztku kadego obiektu
    // (poniewa wszystkie obiekty nale do klas pochodnych
    // klasy Top)
    mptr ** mpp = (mptr**) this;

    // pobiera adres vtbl znajdujcy si 
    // na pocztku reprezentacji obiektu
    mptr * vtbl = *mpp;

    printf("Top::findVtblEntry(%d):  vtbl = 0x%x\n", f, vtbl);

    // przeglda tabel vtbl w poszukiwaniu funkcji
    // element tabeli o indeksie rwnym 0
    // nie jest uywany
    for(int i = 1; vtbl[i].f; ++i ) {
        if (compareFuncs(i, vtbl[i].f, f)) {
            return vtbl + i;
        }
    }
    return 0;
}

// deklaracja funkcji zewntrznej load w jzyku C
extern "C" vptp load(const char *);

void
Top::update(    String filename,
                String fname,
                const char *const TypedefSpec) {

    // aduje funkcj fname z pliku filename.
    // Ostatni parametr umoliwia opcjonalne okrelenie
    // typu wskanika funkcji. Jest on niezbdny, jeli
    // funkcja jest przeciona.
    // Tablica funkcji wirtualnych zostaje odpowiednio
    // zaktualizowana
    // Aktualizowane mog by wycznie funkcje wirtualne.

    const String temp = "/tmp";

    printf("Top::update(\"%s\", \"%s\", \"%s\")\n",
        (const char *)filename, (const char *)fname,
        (const char *)TypedefSpec);
    String prepname = temp + "/" + "t.c";
    String Typedef, cast = "";
    if (strlen(TypedefSpec)) {
        Typedef = String("// uywane w celu rozrnienia\
        funkcji przecionych\n\t\t\ttypedef ") + TypedefSpec;
    } else {
        Typedef = "typedef vptp TYPE";
        cast = "(vptp)";
    }
    // tworzy funkcj pomocnicz zwracajc
    // adres aktualizowanej funkcji
    FILE *tempFile = fopen(prepname, "w");
    fprintf(tempFile, "#\
        include \"includes.h\"\n\
        extern vptp functionAddress() {\n\
            %s;\n\
            TYPE retval = %s&%s;\n\
            return (vptp)retval;\n\
        }\n",
        (const char*)Typedef,
        (const char *)cast,
        (const char*)fname);
    fclose(tempFile);

    // kompiluje funkcj pomocnicz
    String command = String("DIR=`pwd`; cd ") + temp + ";\
        CC +e0 -I$DIR -c -g " + prepname;
    system(command);
    unlink(prepname);
    String objectname =
            prepname(0, prepname.length() - 2) + ".o";

    // aduje funkcj pomocnicz.  Operacja 
    // adowania zwraca adres nowej funkcji.
    vvptp findfunc = (vvptp)load(objectname);
    unlink(objectname);
    printf("Top::update: wywouje findVtblEntry(%d)\n",
                    (*findfunc)());

    // Znajduje odpowiedni element tablicy vtbl
    // dla danje klasy. Wywoywana jest funkcja
    // pomocnicza, aby poinformowa funkcj findVtblEntry 
    // o adresie poszukiwanej funkcji
    mptr *vtblEntry = findVtblEntry((*findfunc)());

    // aduje now wersj aktualizowanej funkcji
    // i umieszcza jej adres w odpowiednim miejscu
    // tabeli vtbl
    printf("Top::update: stara warto vtblEntry->f = 0x%x\n",
        vtblEntry->f);
    printf("Top::update: wywouje load(\"%s\")\n",
        (const char *) filename);
    vtblEntry->f = load(filename);
    printf("Top::update: operacja zakoczona, nowa warto vtblEntry->f = 0x%x\n",
        vtblEntry->f);
}

