/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E V 3 T R I C . C                         //
//                                                            //
//  Kod konwersji obiektw dla trzeciej wersji klasy Triangle //
//                                                            //
//************************************************************//

#include "ev3tri.h"
#include "Map.h"

// --------------------------------------------------------------

class v2Triangle: public ShapeRep {
public:
    Shape make();
    Shape make(Coordinate, Coordinate, Coordinate);
    v2Triangle();
    void move(Coordinate);
    void *operator new(size_t);
    void operator delete(void *);
    void gc(size_t = 0);
    void draw();
    v2Triangle(Exemplar);
    static void init();
private:
    friend Thing *Triangle::cutover();  // ze wzgldu na konwersj
    static void poolInit(size_t);
    Shape make(Coordinate) { return *aShape; }
    Shape make(Coordinate, Coordinate) { return *aShape; }
    Coordinate p1, p2, p3;
};

// --------------------------------------------------------------

// Ponisza mapa wykorzystywana bdzie do zarzdzania
// obiektami poddawanymi konwersji i powstajcymi na 
// skutek konwersji. Dziki temu, jeli pojawi si
// wielokrotnie danie konwersji tego samego obiektu,
// mapa pozwoli zwrci zawsze t sam warto.

Map<Thingp, Thingp> objectMap;

Thing *
Triangle::cutover() {
    // funkcja zwrci wskanik przeksztaconego trjkta
    Triangle *retval = this;

    // instancja przekazana funkcji reprezentuje star
    // wersj klasy; deklaracja tej wersji zostaa
    // zachowana pod nazw v2Triangle;  bieca klasa Triangle
    // jest ju trzeci wersj.
    v2Triangle *old = (v2Triangle *)this;
    Thingp oldtp = this;
    ShapeRep *oldsr = (ShapeRep*)this;

    if (objectMap.element(oldtp)) {
        // jeli obiekt zosta wczeniej
        // poddany konwersji, to nie wymaga
        // jej ponownie
        retval = (Triangle*)(objectMap[oldtp]);
    } else {
        // tworzy now instancj (wersja trzecia)
        // i umieszcza jej adres w rnych wskanikach
        retval = new Triangle;
        ShapeRep *newsr = retval;
        Thingp newtp = retval;

        // kopiuje cz obiektu pochodzc 
        // z klasy bazowej (ShapeRep)
        *newsr = *oldsr;

        // konfiguruje pola nowego obiektu
        retval->exemplarPointer = triangle;
        retval->p1 = old->p1;
        retval->p2 = old->p2;
        retval->p3 = old->p3;
        retval->color = Black;

        // przechowuje nowy obiekt
        objectMap[oldtp] = newtp;
    }
    return retval;
}

Triangle::Triangle() { }

