/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E V 2 T R I . H                           //
//                                                            //
//     Zmodyfikowany interfejs klasy Triangle (wersja druga)  //
//                                                            //
//************************************************************//

#define _TRIANGLE_H
#ifndef _SHAPEREP_H
#include "eshaprp.h"
#endif
#ifndef _COORDINATE_H
#include "ecoord.h"
#endif

class Triangle: public ShapeRep {
public:
    // deklaracja jak w pliku Triangle.h
    // jedynie funkcja Triangle::move otrzyma now definicj
    Shape make();
    Shape make(Coordinate, Coordinate, Coordinate);
    Triangle();
    void draw();
    void move(Coordinate);
    void rotate(double);
    void *operator new(size_t);
    void operator delete(void *);
    void gc(size_t = 0);
    Triangle(Exemplar);
    static void init();
private:
    static void poolInit(size_t);
    Shape make(Coordinate) { return *aShape; }
    Shape make(Coordinate, Coordinate) { return *aShape; }
    Coordinate p1, p2, p3;
private:
    static char *heap;
    static size_t poolInitialized;
    enum { PoolSize = 10 };
};

extern ShapeRep *triangle;

