/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    T R I . H                                 //
//                                                            //
//         Interfejs klasy Triangle                           //
//                                                            //
//************************************************************//

// Poniej przedstawiony zosta interfejs kodu 
// implementujcego semantyk trjktw.

#define _TRIANGLE_H
#ifndef _SHAPEREP_H
#include "eshaprp.h"
#endif
#ifndef _COORDINATE_H
#include "ecoord.h"
#endif

class Triangle: public ShapeRep {
public:
    // konstruktory wykorzystujce przykad
    Shape make();
    Shape make(Coordinate, Coordinate, Coordinate);

    // zarzdzanie pamici
    void *operator new(size_t);
    void operator delete(void *);
    void gc(size_t = 0);

    // semantyka aplikacji
    void draw();
    void rotate(double);
    void move(Coordinate);

    // procedury klasy
    Triangle(Exemplar);
    Triangle();
    static void init();
private:
    // ponisze funkcje nie powinny by wywoywane
    Shape make(Coordinate);
    Shape make(Coordinate, Coordinate);
private:
    // zmienne stanu instancji
    Coordinate p1, p2, p3;
private:
    // dane zwizane z zarzdzaniem pamici
    static char *heap;
    static size_t poolInitialized;
    enum { PoolSize = 10 };
};

// deklaracja wskanika przykadu klasy Triangle
extern ShapeRep *triangle;

