/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E T R I N G L . C                         //
//                                                            //
//         Implementacja klasy Triangle                       //
//                                                            //
//************************************************************//

#include "etringl.h"

// zmienne specyficzne dla klasy
ShapeRep *triangle = 0;
char *Triangle::heap = 0;
size_t Triangle::poolInitialized = 0;

void
Triangle::init() {
    // inicjuje zmienne statyczne i globalne specyficzne dla klasy Triangle.
    // Inicjacja struktur danych wykonywana jest podczas pierwszego
    // wywoania funkcji ShapeRep::gcCommon 
    triangle = new Triangle(Exemplar(0));
}

Shape
Triangle::make()
{
    // tworzy domylny (zdegenerowany) trjkt
    Triangle *retval = new Triangle;
    retval->p1 = retval->p2 = retval->p3 = Coordinate(0,0);
    retval->exemplarPointer = this;
    return *retval;
}

Shape
Triangle::make(Coordinate pp1, Coordinate pp2, Coordinate pp3)
{
    // inicjuje i zwraca nowy obiekt klasy Triangle
    Triangle *retval = new Triangle;
    retval->p1 = pp1;
    retval->p2 = pp2;
    retval->p3 = pp3;
    retval->exemplarPointer = this;
    return *retval;
}

void
Triangle::gc(size_t nbytes) {
    // przekazuje struktury pamici wykorzystywane przez klas Triangle 
    // do wsplnej funkcji odzyskiwania nieuytkw (zamiatania) w klasie bazowej
    gcCommon(nbytes, poolInitialized, PoolSize, heap);
}

void
Triangle::draw() {
    // w obecnej wersji wywietla jedynie 
    // pozycj obiektu w puli
    int Sizeof = poolInitialized? poolInitialized:
        Round(sizeof(Triangle));
    printf("<obiekt klasy Triangle %c>",
        'A' + (((char *)this-(char *)heap)/Sizeof));
}

void
Triangle::move(Coordinate) {
    // . . .
}

void
Triangle::rotate(double) {
    // . . .
}

void *
Triangle::operator new(size_t nbytes) {
    // jeli pula nie zostaa jeszcze zainicjowana lub wanie
    // wykonana zostaa aktualizacja klasy Triangle, to 
    // sterowanie przekazywane jest funkcji odzyskiwania
    // nieuytkw
    if (poolInitialized - nbytes) {
        gcCommon(nbytes, poolInitialized, PoolSize, heap);
        poolInitialized = nbytes;
    }

    // szuka wolnego bloku
    Triangle *tp = (Triangle *)heap;
    // przydaaby si kontrola zuycia pamici
    while (tp->inUse) {
        tp = (Triangle*)(((char*)tp) + Round(nbytes));
    }

    // inicjuje znaczniki
    tp->gcmark = 0;
    tp->inUse = 1;
    return (void*) tp;
}

void Triangle::operator delete(void *) {
    // nie powinien by wywoywany, ale jzyk C++ 
    // wymaga jego obecnoci, jeli zdefiniowany
    // zosta operator new
}

Triangle::Triangle() { }  // zna rozmiar obiektu i umieszcza pole vptr 

Triangle::Triangle(const Triangle& t) {
    // konstruktor kopiujcy
    p1 = t.p1;
    p2 = t.p2;
    p3 = t.p3;
}

Triangle::Triangle(Exemplar e) : ShapeRep(e) {
    // tworzy przykad klasy Triangle
}

Shape
Triangle::make(Coordinate) {
    // fikcyjna funkcja - nie powinna by wywoywana
    return *aShape;
}

Shape
Triangle::make(Coordinate, Coordinate) {
    // fikcyjna funkcja - nie powinna by wywoywana
    return *aShape;
}

