/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    E S H A P E . H                           //
//                                                            //
//         Interfejs klasy Shape                              //
//                                                            //
//************************************************************//

// Klasa Shape stanowi interfejs uytkownika dla caego
// pakietu graficznego. Zadaniem pozostaych klas jest 
// jedynie jego implementacja.

#ifndef _SHAPE_H
#define _SHAPE_H
#include "ek.h"
#endif
#include "List.h"

// deklaracja wyprzedzajca
class ShapeRep;

class Shape: public Top {    // Top zdefiniowana w pliku k.h
public:
    // przekazuje wszystkie operacje obiektowi rep
    ShapeRep *operator->() const {
        return rep;
    }

    // konstruktory i ortodoksyjna posta kanoniczna
    Shape();
    Shape(ShapeRep&);
    ~Shape();
    Shape(Shape& x);
    Shape& operator=(Shape& x);

    // zwraca typ obiektu listu
    Top *type();
    // zastpuje przykad now wersj
    // i aktualizuje jego instancje
    // za pomoc funkcji cutover
    // dostarczonej przez uytkownika
    void dataUpdate(Thingp&, const Thingp);

    // funkcja pomocnicza oglnego przeznaczenia,
    // ktra moe zosta wykorzystana przez uytkownika
   // do wykonania dowolnych zada
    Top *doit();

    // funkcja odzyskiwania nieuytkw dla klas Shape 
    void gc();

    // funkcje umoliwiajce zarejestrowanie si
    // i wyrejestrowanie si przykadw
    void Register(ShapeRep*);
    void UnRegister(ShapeRep*);

    // inicjuje zmienne klasy
    static void init();    // inicjacja klasy
private:
    friend ShapeRep;
    // operator new wywoywany jest jedynie przez ShapeRep.
    // operator delete nie jest uywany
    static void *operator new(size_t s) {
        return ::operator new(s);
    }
    static void operator delete(void *) { }

    // lista instancji
    static List<Topp> *allShapes;

    // lista przykadw
    // klas pochodnych klasy ShapeRep
    static List<Thingp> *allShapeExemplars;

    // wskanik waciwego obiektu reprezentujcego figur
    ShapeRep *rep;
};

typedef Shape *Shapepointer;

// wskanik przykadu klasy Shape, 
// tworzony dynamicznie przez Shape::init
extern Shape *shape;         // przykad

class Point: public Shape {
public:
    // . . . .
    ShapeRep *operator->() const;
    Point();
    ~Point();
} point;

// uytkownicy nie powinni docza
// pliku nagwkowego klasy ShapeRep

#ifndef _SHAPEREP_H
#include "eshaprp.h"
#endif

