/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

//************************************************************//
//                                                            //
//     P L I K :    R E C T A N G L E . H                     //
//                                                            //
//         Interfejs klasy Rectangle                          //
//                                                            //
//************************************************************//

#define _RECTANGLE_H
#ifndef _SHAPEREP_H
#include "eshaprp.h"
#endif
#ifndef _COORDINATE_H
#include "ecoord.h"
#endif

// Definiuje interfejs abstrakcji Rectangle 

class Rectangle: public ShapeRep {
public:
    // konstruktory wykorzystujce przykady
    Shape make();
    Shape make(Coordinate, Coordinate);

    // konstruktor domylny
    Rectangle();

    // konstruktor przykadu
    Rectangle(Exemplar);
    void draw();

    // Operacje na prostoktach
    void move(Coordinate);
    void rotate(double);

    // Procedury zarzdzania pamici
    void *operator new(size_t);
    void operator delete(void *);
    void gc(size_t = 0);
    static void init();
private:
    // Ponisze funkcje nie powinny by wywoywane dla prostoktw
    Shape make(Coordinate, Coordinate, Coordinate) {
        return *aShape;
    }
    Shape make(Coordinate) {
        return *aShape;
    }
    Coordinate p1, p2;
private:
    // Struktury danych zwizane z zarzdzaniem pamici
    static char *heap;
    static size_t poolInitialized;
    enum { PoolSize = 5 };
};

// Deklaracja wskanika przykadu prostokta
extern ShapeRep *rectangle;

