/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

#include "k.h"
#include "collection.h"

// Kolekcja elementw klasy T indeksowanych wartociami klasy S

template<class T, class S>
    class CollectionRep: public Thing {
    public:
        virtual Collection<T, S> make();
        virtual Thing* cutover(Thing *);
        virtual T& operator[](int);
        virtual T& operator[](S);
        virtual void put(const T&);
        CollectionRep() { }
        ~CollectionRep() { }
        Thing *type();
    protected:
        friend class Collection<T, S>;
        static void *operator new(size_t l) {
            return ::operator new(l);
        }
        static void operator delete(void *p) {
            ::operator delete(p);
        }
    private:
        CollectionRep<T, S> *exemplarPointer;
    };

