/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

class Telephone {
public:
    enum PhoneType { POTS, ISDN, OPERATOR, OTHER } phoneType()
        { return phoneTypeVal; }
    void ring();
    Bool isOnHook();
    Bool isTalking();
    Bool isDialing();
    DigitString collectDigits();
    LineNumber extension();  
    ~Telephone();
protected:
    LineNumber extensionData;
    PhoneType phoneTypeVal;
    Telephone();
};

class POTSPhone: public Telephone {
public:
    Bool runDiagnostics();
    POTSPhone(): phoneTypeVal(POTS) . . . .  {
        . . . .
    }
    POTSPhone(POTSPhone &p): phoneTypeVal(POTS) . . . .  {
        . . . .
    }
    ~POTSPhone();
private:
    Frame frameNumberVal;
    Rack rackNumberVal;
    Pair pairVal;
};

class ISDNPhone: public Telephone {
public:
    ISDNPhone(): phoneTypeVal(ISDN) . . . .   {  . . . .  }
    ISDNPhone(ISDNPhone &p): phoneTypeVal(ISDN) . . . . {
        . . . .
    }
    ~ISDNPhone();
    void sendBPacket();  // wysya pakiet w kanale B
    void sendDPacket();  // wysya pakiet w kanale D
private:
    Channel b1, b2, d;
};

