/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

enum Bool {true, false} ;

class Telephone {
public:
    void ring();
    Bool isOnHook();
    Bool isTalking();
    Bool isDialing();
    DigitString collectDigits();
    LineNumber extension();
    ~Telephone();
protected:
    LineNumber extensionData;
    Telephone();
};

// POTS oznacza tradycyjn telefoni analogow (Plain Ordinary Telephone Service)

class POTSPhone: public Telephone {
public:
    Bool runDiagnostics();
    POTSPhone();
    POTSPhone(POTSPhone&);
    ~POTSPhone();
private:
    // szczegy opisujce sposb 
    // fizycznego przyczenia telefonu do centrali
    Frame frameNumberVal;
    Rack rackNumberVal;
    Pair pairVal;
};

// ISDN oznacza cyfrow telefoni z integracj usug (Integrated Services Digital Network)

class ISDNPhone: public Telephone {
public:
    ISDNPhone();
    ISDNPhone(ISDNPhone&);
    ~ISDNPhone();
    void sendBPacket();
    void sendDPacket();
private:
    Channel b1, b2, d;
};

class PrincessPhone: public POTSPhone {
    . . . .
};

