/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

class String {
friend class StringRep;
public:
    String operator+(const String &s) const { return *p + s; }
    StringRep* operator->() const   { return p; }
    String() {
        (p = new StringRep())->count = 1;
    }
    String(const String& s)  { (p = s.p)->count++; }
    String(const char *s) {
        (p = new StringRep(s))->count = 1;
    }
    String operator=(const String& q) {
        // tym razem nieco inna implementacja
        if (--p->count <= 0 && p != q.p) delete p;
        (p=q.p)->count++; return *this; 
    }
    ~String()       { if (--p->count<=0) delete p; }
private:
    String(char** r) {
        p = new StringRep(r);
    }
    StringRep *p;
};

