/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

#include <complex.h>

typedef double time;

class SeriesRLCStepResponse {
public:
    complex (SeriesRLCStepResponse::*current)(time t);
    SeriesRLCStepResponse(double r, double l,
        double c, double initialCurrent);
    double frequency() const { return 1.0 / sqrt(L * C); }
private:
    complex underDampedResponse(time t) {
        return exp(-alpha * t) * (b1 * cos(omegad * t) +
               b2 * sin(omegad * t));
    }
    complex overDampedResponse(time t) {
        return a1 * exp(s1 * t) + a2 * exp(s2 * t);
    }
    complex criticallyDampedResponse(time t) {
        return exp(-alpha * t) * (a1 * t + a2);
    }
    double R, L, C, currentT0, alpha;
    complex omegad, a1, b1, a2, b2, s1, s2;
};

