/* Copyright (c) 1992 AT&T Bell Laboratories. */
/* C++. Styl i technika zaawansowanego programowania */
/* James O. Coplien */
/* Wszystkie prawa zastrzeone. */

const int STACK_SIZE = 10;

class Stack {
public:
    Stack();
    Stack(int);
    ~Stack();
    long top() const;
    long pop();
    void push(long);
private:
    long *items;
    int sp;
};

Stack::Stack() {
    items = new long[STACK_SIZE];
    sp = -1;
}

Stack::Stack(int size) {
    items = new long[size]; // jak deklaracja typ[] lub wywoanie funkcji malloc,
                            //  z t rnic, e wywoywany jest konstruktor
                            //  (jesli jest dostpny)
    sp = -1;
}

Stack::~Stack() {
    delete[] items;         // jak wywoanie funkcji free,
                            //  ale wywoywany jest destruktor
}

long Stack::top() const {
    return items[sp];
}

long Stack::pop() {
    return items[sp--];
}

void Stack::push(long i) {
    items[++sp] = i;
}

int main()
{
    Stack q;        // wywoanie Stack::Stack()
    Stack r(15);    // wywoanie Stack::Stack(int)
    q.push(1);
    long i = q.top();
    q.pop();
}

