// ldep.c
#include "idep_linkdep.h"
#include <iostream.h>

// Ten plik zawiera gwny program wykorzystujcy komponent idep_linkdep.
#define NL "\n"
static const char *help()
{
return NL
"ldep: Analizuje zalenoci fazy konsolidacji grupy komponentw."                               NL
""                                                                                              NL
"  Wiersz polecenia ma nastpujc posta:"                                                     NL
""                                                                                              NL
"    ldep [-U<katalog>] [-u<un>] [-a<aliasy>] [-d<zalezn>] [-l|-L] [-x|-X] [-s]"                NL
""                                                                                              NL
"      -U<katalog> Okrelenie katalogu, ktry nie ma byc grupowany jako pakiet."                NL
"      -u<un>      Okrelenie pliku zawierajcego nazwy katalogw, ktrych nie nalezy grupowa."NL
"      -a<aliasy>  Okreslenie pliku zawierajcego list aliasw nazw komponentw."              NL
"      -d<zalezn>  Okrelenie pliku zawierajcego list zalenoci fazy kompilacji."            NL
"      -l          Dugi listing: lista zalenoci nieredundantnych."                           NL
"      -L          Dugi listing: pena lista zalenoci."                                      NL
"      -x          Wyczenie wywietlania informacji dotyczcych aliasw/odwoania aliasw."   NL
"      -X          Wyczenie wywietlania wszystkich nazw komponentw poza numerami poziomw." NL
"      -s          Zakaz usuwania rozszerze. Kazdy plik analizowany osobno."                   NL
""                                                                                              NL
"    Polecenie nie pobiera argumentw. Zalenoci bd pochodzic ze standardowego urzdzenia"   NL
"    wejsciowego, chyba, e uyjemy opcji -d."                                                  NL
""                                                                                              NL
"  TYPOWE ZASTOSOWANIE:"                                                                        NL
""                                                                                              NL
"    ldep -aaliasy -dzaleznosci"                                                                NL
NL;
}

static enum { IOERROR = -1, SUCCESS = 0, DESIGN_ERROR = 1 } s_status = SUCCESS;

static ostream& err()
{
    s_status = IOERROR;
    return cerr << "Bd: ";
}

static int missing(const char *argName, char option)
{
    err() << "brakujcy argument`" << argName << "' dla opcji -"
          << option << "." << endl;
    return s_status;
}

static int extra(const char *text, char option)
{
    err() << "wykryto dodatkowy tekst \"" << text << "\" za opcj -"
          << option << "." << endl;
    return s_status;
}

static int unreadable(const char *dirFile, char option)
{
    err() << "nie mona odczyta pliku \"" << dirFile << "\" dla opcji -"
          << option << "." << endl;
    return s_status;
}

static int incorrect(const char *file, char option)
{
    err() << "plik \"" << file << "\" zawiera niepoprawn zawarto dla opcji -"
          << option << "." << endl;
    return s_status;
}

static const char *getArg(int *i, int argc, const char *argv[])
{
    return 0 != argv[*i][2] ? argv[*i] + 2 :
           ++*i >= argc || '-' == argv[*i][0] ? "" : argv[*i];
}
int main (int argc, const char *argv[])
{
    int fileFlag = 0;        // uycie opcji -d<plik> ustawia t warto na 1
    int longListingFlag = 0; // uycie opcji -l lub -L ustawia t warto na 1
    int canonicalFlag = 1;   // uycie opcji -L ustawia t warto na 0, natomiast
                             // uycie opcji -l ustawia j z powrotem na 1
    int suffixFlag = 1;      // uycie opcji -s ustawia te warto na 1
    int suppression = 0;     // uycie opcji -x ustawia t warto na 1; -X ustawia j na 2.
    idep_LinkDep environment;
    for (int i = 1; i < argc; ++i) {
        const char *word = argv[i];
        if  ('-' == word[0]) {
            char option = word[1];
            switch(option) {
              case 'U': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("katalog", option);
                }
                environment.addUnaliasDirectory(arg);
              } break;
              case 'u': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                if (0 != environment.readUnaliasDirectories(arg)) {
                    return unreadable(arg, option);
                }
              } break;
              case 'a': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                int s = environment.readAliases(cerr, arg);
                if (s < 0) {
                    return unreadable(arg, option);
                }
                if (s > 0) {
                    return incorrect(arg, option);
                }
              } break;
              case 'd': {
                const char *arg = getArg(&i, argc, argv);
                if (!*arg) {
                    return missing("plik", option);
                }
                environment.addDependencyFile(arg);
                fileFlag = 1;
              } break;
              case 'l': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                canonicalFlag = 1;
                longListingFlag = 1;
              } break;
              case 'L': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                longListingFlag = 1;
                canonicalFlag = 0;
              } break;
              case 's': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                suffixFlag = 0;
              } break;
              case 'x': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                suppression = 1;
              } break;
              case 'X': {
                const char *arg = word + 2;
                if (*arg) {
                    return extra(arg, option);
                }
                suppression = 2;
              } break;
              default: {
                 err() << "nieznana opcja \"" << word << "\"." << endl
                       << help();
                 return s_status;
              } break;
            }
        }
        else {
             err() << "niepoprawny argument \"" << word << "\"." << endl
                   << help();
             return s_status;
        }
    }

    if (!fileFlag) {
        environment.addDependencyFile(""); // "" jest synonimem standardowego urzdzenia wejciowego
    }

    int result = environment.calculate(cerr, canonicalFlag, suffixFlag);

    s_status = result < 0 ? IOERROR : result > 0 ? DESIGN_ERROR : SUCCESS; 

    if (s_status >= 0) {
        if (0 == suppression) {
            environment.printAliases(cout);
            environment.printUnaliases(cout);
        }
        environment.printCycles(cerr);
        environment.printLevels(cout, longListingFlag, suppression >= 2);
        if (suppression <= 1) {
            environment.printSummary(cout);
        }
    }

    return s_status;
}

