// idep_tokeniter.h
#ifndef INCLUDED_IDEP_TOKENITER
#define INCLUDED_IDEP_TOKENITER

// W tym komponencie zdefiniowano 1 w peni odizolowan klas iteratora:
//   idep_TokenIter: iterator cigw w strumieniu wejciowym

class istream;

class idep_TokenIter_i;
class idep_TokenIter {
    idep_TokenIter_i *d_this;

  private:
    idep_TokenIter(const idep_TokenIter&);              // nie zaimplementowano
    idep_TokenIter& operator=(const idep_TokenIter&);   // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_TokenIter(istream& in);
        // Utworzenie iteratora cigw dla okrelonego strumienia. "Cigiem" znak
        // koca wiersza ('\n') lub "sowo" skadajce si z cigej sekwencji znakw         
        // nie zawierajcej spacji.  Obiekt strumienia musi istnie przez cay czas         
        // korzystania z iteratora.

    ~idep_TokenIter();

    void operator++();
        // Przejcie do nastpnego cigu (tzn., "sowa" lub nowego wiersza). Jeeli         
        // status iteracji nie jest poprawny, dziaanie funkcji jest nieokrelone. 

    // METODY DOSTPOWE
    operator const void *() const;
        // Zwraca warto niezerow, jezeli biecy cig jest poprawny. W przeciwnym         
        // przypadku zwraca 0.
    const char *operator()() const;
        // Zwraca biecy cig (tzn., "sowo" lub znak koca wiersza). Jeeli
        // status iteracji nie jest poprawny, dziaanie funkcji jest nieokrelone.
};

#endif

