// idep_string.h
#ifndef INCLUDED_IDEP_STRING
#define INCLUDED_IDEP_STRING

// W tym komponencie - liciu zdefiniowano 1 klas:
//   idep_String: zarzdzany cig znakw

// Uwaga: przekazanie do dowolnej z funkcji w tym komponencie argumentu w postaci wskanika o 
//        wartoci null moe spowodowa nieprzewidziane skutki.
class idep_String {
    char *d_string_p;

  public:
    // METODY TWORZCE
    idep_String();
    idep_String(const idep_String& idep_string);
    idep_String(const char *str);
    ~idep_String();

    // METODY OBLICZENIOWE
    idep_String &operator=(const idep_String& idep_string);
    idep_String &operator=(const char* str);

    idep_String& operator+=(const idep_String& idep_string);
    idep_String& operator+=(const char* str);
        // Konkatenacja z biecym obiektem opisujcym cig znakw.

    // METODY DOSTPOWE
    operator const char*() const;
        // Zwraca wskanik do podstawowej reprezentacji cigu znakw zakoczonego         
        // znakiem null. Uwaga: ten wskanik jest poprawny tylko do momentu modyfikacji         
        // lub zniszczenia obiektu.

    int length() const;
        // Zwraca dugo biecego cigu. Warto zwrci uwag, e zastosowanie tej metody         
        // umoliwia klientom wydajne wykorzystywanie alternatyw         
        // implementacyjnych w szerszym zakresie.
};

// WOLNE OPERATORY

idep_String operator+(const idep_String& idep_string, const char *str);
idep_String operator+(const char* str, const idep_String& idep_string);
idep_String operator+(const idep_String& left, const idep_String& right);
    // Konkatenacja: trzy odmiany w celu uniknicia niejednoznacznoci oraz dla lepszej wydajnoci.
int operator==(const idep_String& left, const idep_String& right);
int operator!=(const idep_String& left, const idep_String& right);
int operator> (const idep_String& left, const idep_String& right);
int operator>=(const idep_String& left, const idep_String& right);
int operator< (const idep_String& left, const idep_String& right);
int operator<=(const idep_String& left, const idep_String& right);
    // Leksykograficzne porwnanie: (const idep_String&) oraz (const idep_String&).
int operator==(const idep_String& idep_string, const char *str);
int operator!=(const idep_String& idep_string, const char *str);
int operator> (const idep_String& idep_string, const char *str);
int operator>=(const idep_String& idep_string, const char *str);
int operator< (const idep_String& idep_string, const char *str);
int operator<=(const idep_String& idep_string, const char *str);
    // Leksykograficzne porwnanie: (const idep_String&) i (const char *).
int operator==(const char* str, const idep_String& idep_string);
int operator!=(const char* str, const idep_String& idep_string);
int operator> (const char* str, const idep_String& idep_string);
int operator>=(const char* str, const idep_String& idep_string);
int operator< (const char* str, const idep_String& idep_string);
int operator<=(const char* str, const idep_String& idep_string);
    // Leksykograficzne porwnanie: (const char *) i (const idep_String&).
# endif

