// idep_namearray.h
#ifndef INCLUDED_IDEP_NAMEARRAY
#define INCLUDED_IDEP_NAMEARRAY

// W tym komponencie - liciu zdefiniowano 1 klas:
//   idep_NameDep: rozszerzalna tablica cigw znakw nazw.
class ostream;

class idep_NameArray {
    char **d_array_p;   // tablica zaalokowanych dynamicznie cigw znakw
    int d_size;         // fizyczny rozmiar tablicy
    int d_length;       // logiczny rozmiar tablicy

  private:
    idep_NameArray(const idep_NameArray&);              // nie zaimplementowano
    idep_NameArray& operator=(const idep_NameArray&);   // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_NameArray(int maxEntriesHint = 0);
        // Utworzenie tablicy cigw znakw o zmiennym rozmiarze.
        // Tablica bdzie zaalokowana przy zaoeniu maksymalnej spodziewanej liczby pozycji         
        // okrelonej za pomoc opcjonalnego argumentu maxEntriesHint. 
        // Domylnie bdzie zaalokowana tablica o do niewielkim rozmiarze.

    ~idep_NameArray();
        // Usunicie tablicy wraz z zawartymi w niej kopiami cigw znakw oznaczajcych nazwy.

    // METODY OBLICZENIOWE
    int append(const char *newName);
        // Dodanie kopii okrelonego cigu znakw na kocu tablicy. 
        // Metoda zwraca warto nowego indeksu. Metoda nie sprawdza,
        // czy cigi znakw powtarzaj si.

    // METODY DOSTPOWE
    const char *operator[] (int index) const;
        // Zwraca wskanik do cigu znakw wymienionego jako argument. Cigi znakw s 
        // zapisywane pod kolejnymi nieujemnymi indeksami, rozpoczynajc od 0, a skoczywszy 
        // na wartoci rwnej biecemu rozmiarowi pomniejszonemu o jeden.  W przypadku 
        // przekroczenia zakresu indeksu, zwracany jest pusty wskanik.

    int length() const;
        // Zwraca biec liczb nazw przechowywanych w tablicy.
};

ostream& operator<<(ostream& out, const idep_NameArray& array);
    // Wywietla logiczn zawarto tablicy nazw na podanym strumieniu wyjciowym w 
    // odpowiednim formacie.

#endif
        
