// idep_linkdep.h
#ifndef INCLUDED_IDEP_LINKDEP
#define INCLUDED_IDEP_LINKDEP

// W tym komponencie - opakowaniu zdefiniowano 8 w peni odizolowanych klas:
//          idep_LinkDep: rodowisko do analizy zalenoci konsolidacji 
//        idep_AliasIter: iterator wymienionych par aliasw
//      idep_UnaliasIter: iterator wymienionych katalogw wyczonych z aliasu
//        idep_CycleIter: iterator cykli w systemie
//       idep_MemberIter: iterator elementw okrelonego cyklu 
//        idep_LevelIter: iterator poziomw systemu
//    idep_ComponentIter: iterator komponentw danego poziomu
//   idep_DependencyIter: iterator zalenoci danego komponentu

class ostream;
class idep_AliasIter;
class idep_UnaliasIter;
class idep_CycleIter;
class idep_MemberIter;
class idep_LevelIter;
class idep_ComponentIter;
class idep_DependencyIter;

class idep_LinkDep_i;
class idep_LinkDep {
    idep_LinkDep_i *d_this;

    friend idep_AliasIter;
    friend idep_UnaliasIter;
    friend idep_CycleIter;
    friend idep_MemberIter;
    friend idep_LevelIter;
    friend idep_ComponentIter;
    friend idep_DependencyIter;

  private:
    idep_LinkDep(const idep_LinkDep&);                  // nie zaimplementowano
    idep_LinkDep& operator=(const idep_LinkDep&);       // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_LinkDep();
    ~idep_LinkDep();

    // METODY OBLICZENIOWE
    void addDependencyFile(const char *fileName);
        // Dodanie pliku zawierajcego zalenoci do analizy skadniowej. Podczas fazy oblicze
        // bd zgaszane bdy skadniowe.  Naley zwrci uwag, e pusty cig znakw
        // ("") jest interpretowany jako <stdin> (standardowe urzdzenie wejciowe). 

    const char *addAlias(const char *aliasName, const char *componentName);
        // Dodanie do zbioru aliasw pary alias/komponent. Funkcja zwraca 0 w przypadku         
        // sukcesu lub cig znakw zawierajcy nazw komponentu,         
        // ktra poprzednio odpowiadaa temu aliasowi, inny od cigu okrelonego za pomoc         
        // argumentu tej funkcji.

    int readAliases(ostream& err, const char *file);
        // Odczytanie listy aliasw komponentw z okrelonego pliku. Kada
        // ciga sekwencja znakw nie zawierajca spacji reprezentuje nazw.
        // Nazwy s rwnie uoone w sekwencje. Pierwsza nazwa w sekwencji nazw
        // reprezentuje waciw nazw komponent.  
        // Nazwy w tym samym wierszu (sekwencja pozioma) lub w kolejnych wierszach
        // (sekwencja pionowa) s interpretowane jako aliasy tej nazwy komponentu.          
        // Sekwencja pozioma koczy si znakiem koca wiersza ('\n')
        // o ile nie jest poprzedzona znakiem odwrotnego ukonika ('\\').  Sekwencja pionowa         
        // koczy si pustym wierszem.  W przypadku powodzenia funkcja zwraca 0 bez wywietlania         
        // adnych komunikatw.  Jeeli wymieniony plik nie daje si odczyta, funkcja
        // zwraca -1 (bez komunikatw).  W przypadku napotkania aliasu, ktry jest niespjny
        // z aliasem wymienionym poprzednio, jest on wywietlany na standardowym         
        // urzdzeniu bdu.  Po zakoczeniu analizy, funkcja zwraca liczb niezgodnych         
        // aliasw.

    void addUnaliasDirectory(const char *dirName);
        // Dodanie katalogu, ktry domylnie nie ma by traktowany jako osobna jednostka.
        // Funkcja nie ma adnego efektu, jeeli katalog wymieniono ju wczeniej.

    int readUnaliasDirectories(const char *file);
        // Odczytanie z okrelonego pliku listy katalogw do wyaczenia z aliasu z okrelonego.
        // W tej funkcji zaoono, e kada ciga sekwencja znakw bez spacji
        // reprezentuje katalog, ktry ma by dodany.  Funkcja zwraca warto 0, chyba e               
        // okrelony plik nie daje si odczyta lub zawiera znaki spoza podstawowego
        // kodu ASCII.

    int calculate(ostream& err, int canonicalFlag = 1, int suffixFlag = 0);
        // Obliczenie zalenoci komponentu fazy konsolidacji. Zwraca warto 0 w przypadku         
        // powodzenia, w przeciwnym przypadku warto rn od zera.  W przypadku wystpienia         
        // bdu wejcia - wyjcia wynik dziaania funkcji bdzie negatywny, a obiekt         
        // pozostanie w stanie niewany.
        // W innym przypadku zostanie zwrcona liczba komponentw wchodzcych w skad                 
        // cyklicznych zalenoci. Szczegowe bdy bd zgoszone na wskazanym
        // strumieniu bdw (err). Niezerowa warto argumentu canocialFlag oznacza         
        // danie kanonicznej reprezentacji zalenoci -- tzn. takich, ktre nie zawieraj         
        // redundantnych, przechodnich krawdzi.  Przesonicie tego domylnego         
        // dziaania spowoduje pozostawienie kompletnego (tranzytywnego) grafu. Rwnie         
        // domylnie nastpuje obcicie wszystkich rozszerze plikw. Przekazanie niezerowej 
        // wartoci opcjonalnego argumentu suffixFlag powoduje, e poszczeglne pliki komponentu 
        // s traktowane jako oddzielne jednostki fizyczne.

    // METODY DOSTPOWES
    int numComponents() const;
        // Zwraca cakowit liczb komponentw w systemie.          
        // Uwaga: Liczba ta jest sum liczby lokalnych komponentw oraz liczby pakietw         
        // zewntrznych. Nie suy ona do obliczania wspczynnikw ACD i NCCD.

    int numLocalComponents() const;
        // Zwraca liczb komponentw (lokalnych) -- tzn. takich, ktrych poziom > 0.
        // Uwaga: jest to warto suca do obliczania wspczynnikw ACD i NCCD.

    int numPackages() const;
        // Zwraca liczb elementw na poziomie 0. Naley zwrci uwag, e komponenty lokalne         
        // nie zawierajce zalenoci zewntrznych (wcznie z dyrektyw include standardowej         
        // biblioteki kompilatora) bd niepoprawnie interpretowane jako nalece do pakietu. 
        // Dodanie fikcyjnej zalenoci od jzyka ("C++") lub lokalnego katalogu (".") 
        // rozwizuje problem.

    int numLevels() const;
        // Zwraca liczb poziomw komponentw (lokalnych) w biecym podsystemie. 
        // Warto reprezentuje "gboko" grafu zalenoci komponentw (lokalnych).

    int numCycles() const;
        // Zwraca liczb lokalnych cykli w tym podsystemie

    int numMembers() const;
        // Zwraca liczb komponentw podsystemu zalenych cyklicznie.

    int ccd() const;
        // Zwraca wspczynnik Skumulowanych Zalenoci Kopmponentu (CDD) dla tego 
        // podsystemu przy zaoeniu, e elementy poziomu 0 maj wag 0.

    double acd() const;
        // Zwraca warto wspczynnika rednich zalenoci komponentu (ACD) 
        // dla tego podsystemu w przypadku pominicia elementw poziomu 0.

    double nccd() const;
        // Zwraca warto wspczynnika znormalizowanych skumulowanych zalenoci 
        // komponentu (NCCD) dla tego podsystemu z pominiciem elementw poziomu 0.

    void printAliases(ostream& out) const;
        // Wywietlenie aliasw danego rodowiska na okrelonym strumieniu wyjciowym.

    void printUnaliases(ostream& out) const;
        // Wywietlenie wszystkich odwoa aliasw w okrelonym rodowisku na 
        // podanym strumieniu wyjciowym

    void printCycles(ostream& out) const;
        // Wywietlenie wszystkich komponentw zalenych cyklicznie na podanym 
        // strumieniu wyjciowym.

    void printLevels(ostream& out, int longFlag = 0,
                                   int supressFlag = 0) const;
        // Wywietlenie wszystkich komponentw w porzdku poziomw na 
        // podanym strumieniu wyjciowym. Jeeli opcjonalny argument longFlag 
        // ma warto rn od 0 to nastpi jawne okreslenie zalenoci wszystkich 
        // komponentw. W innym przypadku analiza bdzie obejmowa tylko komponenty 
        // oraz odpowiadajce im poziomy. Domylnie wywietlany wynik bdzie zawiera 
        // poziomy komponentw oraz identyfikujce je przyrostki cykli. Jeeli warto 
        // opcjonalnego argumentu supressFlag bdzie rna od 0, wwczas wynik bdzie 
        // zawiera jedynie nazwy komponentw, a poziomy bd od siebir oddzielone 
        // tylko dodatkowym pustym wierszem.

    void printSummary(ostream& out) const;
        // Wywietlenie statystyk charakteryzujcych zalenoci tego pakietu na podanym 
        // strumieniu wyjciowym.  Statystyki te obejmuj nastpujce elementy:
        //
        //   Komponenty  Liczba komponentw (lokalnych) na poziomie wyszym od 0 (tzn. liczba                          
        //               komponentw, ktre maj co najmniej jedn zaleno).
        //
        //   Poziomy     Wysoko grafu zaleznoci komponentu.
        //
        //   Pakiety     Liczba pozycji na poziomie 0 (tzn. komponentw bez zalenoci).
        //
        //   CCD         Suma C(i) wszystkich (lokalnych) komponentw potrzebnych do          
        //               konsolidacji  i testowania komponentu C(i).
        //
        //   ACD         Stosunek wartoci wspczynnika CCD do liczby
        //               komponentw (lokalnych).
        //
        //   NCCD        Stosunek wartoci wspczynnika CCD do wartoci wspczynnika CCD         
        //               zrwnowaonego binarnego drzewa zalenoci o takiej samej liczbie         
        //               komponentw lokalnych. (Uwaga: W przypadku wikszoci architektur         
        //               pakietw wysokiej jakoci warto ta nie przekracza zbytnio wartoci         
        //               1.00).
        //
        // W przypadku istnienia cyklicznych zalenoci komponentu, elementy kadego         
        // maksymalnego cyklu identyfikowane s za pomoc unikalnego indeksu cyklu ujtego w         
        // nawiasy trjktne ('<' oraz '>'). Na podanym strumieniu wyjciowym wywietlany         
        // jest dodatkowy wiersz podsumowania poprzedzajcy pozostae:
        //
        //   Cykle       Liczba rnych maksymalnych cykli na grafie zalenoci komponentu.
        //
        //   Elementy    Cakowita liczba komponentw wchodzcych w skad cykli.
};

ostream& operator<<(ostream& out, const idep_LinkDep& dep);
        // Wywietla wszystkie dostpne informacje w okrelonym rodowisku na podanym         
        // strumieniu wyjciowym. Informacje te obejmuj:
        //   odwoania aliasw: katalogi, ktrych nie naley grupowa
        //              aliasy: odwzorowania nazw plikw komponentw
        //               cykle: maksymalny niezaleny podgraf
        //             poziomy: komponenty w porzdku poziomw razem z zalenociami
        //        podsumowanie: statystyki charakteryzujce zalenoci lokalnego komponentu 
  class idep_AliasIter_i;
class idep_AliasIter {
    idep_AliasIter_i *d_this;

  private:
    idep_AliasIter(const idep_AliasIter&);              // nie zaimplementowano
    idep_AliasIter& operator=(const idep_AliasIter&);   // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_AliasIter(const idep_LinkDep& linkDep);
    ~idep_AliasIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *fromName() const;
        // Zwraca nazw biecego aliasu.

    const char *toName() const;
        // Zwraca waciw nazw
};

class idep_UnaliasIter_i;
class idep_UnaliasIter {
    idep_UnaliasIter_i *d_this;

  private:
    idep_UnaliasIter(const idep_UnaliasIter&);              // nie zaimplementowano
    idep_UnaliasIter& operator=(const idep_UnaliasIter&);   // nie zaimplementowano
  public:
    // METODY TWORZCE
    idep_UnaliasIter(const idep_LinkDep& linkDep);
    ~idep_UnaliasIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *operator()() const;
        // Zwraca biec nazw (katalogu), dla ktrej odwoano alias.
};

class idep_CycleIter_i;
class idep_CycleIter {
    idep_CycleIter_i *d_this;

    friend idep_MemberIter;

  private:
    idep_CycleIter(const idep_CycleIter&);              // nie zaimplementowano
    idep_CycleIter& operator=(const idep_CycleIter&);   // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_CycleIter(const idep_LinkDep& linkDep);
    ~idep_CycleIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    int weight() const;
        // Zwraca liczb elementw biecego (maksymalnego) cyklu.

    int cycle() const;
        // Zwraca dodatni indeks biecego cyklu.
};

class idep_MemberIter_i;
class idep_MemberIter {
    idep_MemberIter_i *d_this;

  private:
    idep_MemberIter(const idep_MemberIter&);            // nie zaimplementowano
    idep_MemberIter& operator=(const idep_MemberIter&); // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_MemberIter(const idep_CycleIter& cycleIter);
    ~idep_MemberIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *operator()() const;
        // Zwraca nazw biecego elementu biecego cyklu.
};

class idep_LevelIter_i;
class idep_LevelIter {
    idep_LevelIter_i *d_this;

    friend idep_ComponentIter;

  private:
    idep_LevelIter(const idep_LevelIter&);              // nie zaimplementowano
    idep_LevelIter& operator=(const idep_LevelIter&);   // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_LevelIter(const idep_LinkDep& linkDep);
    ~idep_LevelIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    int operator()() const;
        // Zwraca indeks biecego poziomu.
};

class idep_ComponentIter_i;
class idep_ComponentIter {
    idep_ComponentIter_i *d_this;

    friend idep_DependencyIter;

  private:
    idep_ComponentIter(const idep_ComponentIter&);              // nie zaimplementowano
    idep_ComponentIter& operator=(const idep_ComponentIter&);   // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_ComponentIter(const idep_LevelIter& levelIter);
    ~idep_ComponentIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *operator()() const;
        // Zwraca nazw biecego komponentu na biecym poziomie.

    int cycle() const;
        // zwraca dodatni indeks biecego cyklu lub 0, gdy graf jest acykliczny.
};

class idep_DependencyIter_i;
class idep_DependencyIter {
    idep_DependencyIter_i *d_this;

  private:
    idep_DependencyIter(const idep_DependencyIter&);            // nie zaimplementowano
    idep_DependencyIter& operator=(const idep_DependencyIter&); // nie zaimplementowano

  public:
    // METODY TWORZCE
    idep_DependencyIter(const idep_ComponentIter& componentIter);
    ~idep_DependencyIter();

    // METODY OBLICZENIOWE
    void operator++();

    // METODY DOSTPOWE
    operator const void *() const;
    const char *operator()() const;
        // Zwraca nazw biecego komponentu, od ktrego zaley komponent pocztkowy.

    int level() const;
        // Zwraca poziom biecego komponnetu.

    int cycle() const;
        // zwraca dodatni indeks biecego cyklu lub 0, gdy graf jest acykliczny.
};

#endif



